/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.chat;

import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.events.chat.McMMOChatEvent;
import com.gmail.nossr50.events.chat.McMMOPartyChatEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public abstract class ChatManager {
    protected Plugin plugin;
    protected boolean useDisplayNames;
    protected String chatPrefix;
    protected String senderName;
    protected String displayName;
    protected String message;

    protected ChatManager(Plugin plugin, boolean bl, String string) {
        this.plugin = plugin;
        this.useDisplayNames = bl;
        this.chatPrefix = string;
    }

    protected void handleChat(McMMOChatEvent mcMMOChatEvent) {
        this.plugin.getServer().getPluginManager().callEvent((Event)mcMMOChatEvent);
        if (mcMMOChatEvent.isCancelled()) {
            return;
        }
        this.senderName = mcMMOChatEvent.getSender();
        this.displayName = this.useDisplayNames ? mcMMOChatEvent.getDisplayName() : this.senderName;
        this.message = LocaleLoader.formatString(this.chatPrefix, this.displayName) + " " + mcMMOChatEvent.getMessage();
        this.sendMessage();
        if (mcMMOChatEvent instanceof McMMOPartyChatEvent) {
            McMMOPartyChatEvent mcMMOPartyChatEvent = (McMMOPartyChatEvent)mcMMOChatEvent;
            for (McMMOPlayer mcMMOPlayer : UserManager.getPlayers()) {
                Player player = mcMMOPlayer.getPlayer();
                if (!mcMMOPlayer.isPartyChatSpying()) continue;
                Party party = mcMMOPlayer.getParty();
                if (party != null) {
                    if (party.getName().equalsIgnoreCase(mcMMOPartyChatEvent.getParty())) continue;
                    player.sendMessage(LocaleLoader.getString("Commands.AdminChatSpy.Chat", mcMMOPartyChatEvent.getParty(), this.message));
                    continue;
                }
                player.sendMessage(LocaleLoader.getString("Commands.AdminChatSpy.Chat", mcMMOPartyChatEvent.getParty(), this.message));
            }
        }
    }

    public void handleChat(String string, String string2) {
        this.handleChat(string, string, string2, false);
    }

    public void handleChat(Player player, String string, boolean bl) {
        this.handleChat(player.getName(), player.getDisplayName(), string, bl);
    }

    public void handleChat(String string, String string2, String string3) {
        this.handleChat(string, string2, string3, false);
    }

    public abstract void handleChat(String var1, String var2, String var3, boolean var4);

    protected abstract void sendMessage();
}

