/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.api;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyLeader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public final class PartyAPI {
    private PartyAPI() {
    }

    public static String getPartyName(Player player) {
        if (!PartyAPI.inParty(player)) {
            return null;
        }
        return UserManager.getPlayer(player).getParty().getName();
    }

    public static boolean inParty(Player player) {
        if (UserManager.getPlayer(player) == null) {
            return false;
        }
        return UserManager.getPlayer(player).inParty();
    }

    public static boolean inSameParty(Player player, Player player2) {
        return PartyManager.inSameParty(player, player2);
    }

    public static List<Party> getParties() {
        return PartyManager.getParties();
    }

    @Deprecated
    public static void addToParty(Player player, String string) {
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        Party party = PartyManager.getParty(string);
        if (party == null) {
            party = new Party(new PartyLeader(player.getUniqueId(), player.getName()), string);
        } else if (PartyManager.isPartyFull(player, party)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.PARTY_MESSAGE, "Commands.Party.PartyFull", party.toString());
            return;
        }
        PartyManager.addToParty(UserManager.getPlayer(player), party);
    }

    public static int getMaxPartySize() {
        return Config.getInstance().getPartyMaxSize();
    }

    public static void addToParty(Player player, String string, boolean bl) {
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        Party party = PartyManager.getParty(string);
        if (party == null) {
            party = new Party(new PartyLeader(player.getUniqueId(), player.getName()), string);
        }
        PartyManager.addToParty(UserManager.getPlayer(player), party);
    }

    public static void removeFromParty(Player player) {
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        PartyManager.removeFromParty(UserManager.getPlayer(player));
    }

    public static String getPartyLeader(String string) {
        return PartyManager.getPartyLeaderName(string);
    }

    @Deprecated
    public static void setPartyLeader(String string, String string2) {
        PartyManager.setPartyLeader(mcMMO.p.getServer().getOfflinePlayer(string2).getUniqueId(), PartyManager.getParty(string));
    }

    @Deprecated
    public static List<OfflinePlayer> getOnlineAndOfflineMembers(Player player) {
        ArrayList<OfflinePlayer> arrayList = new ArrayList<OfflinePlayer>();
        for (UUID uUID : PartyManager.getAllMembers(player).keySet()) {
            OfflinePlayer offlinePlayer = mcMMO.p.getServer().getOfflinePlayer(uUID);
            arrayList.add(offlinePlayer);
        }
        return arrayList;
    }

    @Deprecated
    public static LinkedHashSet<String> getMembers(Player player) {
        return (LinkedHashSet)PartyManager.getAllMembers(player).values();
    }

    public static LinkedHashMap<UUID, String> getMembersMap(Player player) {
        return PartyManager.getAllMembers(player);
    }

    public static List<Player> getOnlineMembers(String string) {
        return PartyManager.getOnlineMembers(string);
    }

    public static List<Player> getOnlineMembers(Player player) {
        return PartyManager.getOnlineMembers(player);
    }

    public static boolean hasAlly(String string) {
        return PartyAPI.getAllyName(string) != null;
    }

    public static String getAllyName(String string) {
        Party party = PartyManager.getParty(string).getAlly();
        if (party != null) {
            return party.getName();
        }
        return null;
    }
}

