/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.api;

import com.gmail.nossr50.api.exceptions.InvalidFormulaTypeException;
import com.gmail.nossr50.api.exceptions.InvalidPlayerException;
import com.gmail.nossr50.api.exceptions.InvalidSkillException;
import com.gmail.nossr50.api.exceptions.InvalidXPGainReasonException;
import com.gmail.nossr50.api.exceptions.McMMOPlayerNotFoundException;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class ExperienceAPI {
    private ExperienceAPI() {
    }

    public static boolean isValidSkillType(String string) {
        return PrimarySkillType.getSkill(string) != null;
    }

    public static boolean isNonChildSkill(String string) {
        PrimarySkillType primarySkillType = PrimarySkillType.getSkill(string);
        return primarySkillType != null && !primarySkillType.isChildSkill();
    }

    @Deprecated
    public static void addRawXP(Player player, String string, int n) {
        ExperienceAPI.addRawXP(player, string, (float)n);
    }

    @Deprecated
    public static void addRawXP(Player player, String string, float f) {
        ExperienceAPI.addRawXP(player, string, f, "UNKNOWN");
    }

    public static void addRawXP(Player player, String string, float f, String string2) {
        ExperienceAPI.addRawXP(player, string, f, string2, false);
    }

    public static void addRawXP(Player player, String string, float f, String string2, boolean bl) {
        if (bl) {
            ExperienceAPI.getPlayer(player).beginUnsharedXpGain(ExperienceAPI.getSkillType(string), f, ExperienceAPI.getXPGainReason(string2), XPGainSource.CUSTOM);
            return;
        }
        ExperienceAPI.getPlayer(player).applyXpGain(ExperienceAPI.getSkillType(string), f, ExperienceAPI.getXPGainReason(string2), XPGainSource.CUSTOM);
    }

    @Deprecated
    public static void addRawXPOffline(String string, String string2, int n) {
        ExperienceAPI.addRawXPOffline(string, string2, (float)n);
    }

    @Deprecated
    public static void addRawXPOffline(String string, String string2, float f) {
        ExperienceAPI.addOfflineXP(string, ExperienceAPI.getSkillType(string2), (int)Math.floor(f));
    }

    public static void addRawXPOffline(UUID uUID, String string, float f) {
        ExperienceAPI.addOfflineXP(uUID, ExperienceAPI.getSkillType(string), (int)Math.floor(f));
    }

    @Deprecated
    public static void addMultipliedXP(Player player, String string, int n) {
        ExperienceAPI.addMultipliedXP(player, string, n, "UNKNOWN");
    }

    public static void addMultipliedXP(Player player, String string, int n, String string2) {
        ExperienceAPI.getPlayer(player).applyXpGain(ExperienceAPI.getSkillType(string), (int)((double)n * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()), ExperienceAPI.getXPGainReason(string2), XPGainSource.CUSTOM);
    }

    @Deprecated
    public static void addMultipliedXPOffline(String string, String string2, int n) {
        ExperienceAPI.addOfflineXP(string, ExperienceAPI.getSkillType(string2), (int)((double)n * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()));
    }

    @Deprecated
    public static void addModifiedXP(Player player, String string, int n) {
        ExperienceAPI.addModifiedXP(player, string, n, "UNKNOWN");
    }

    public static void addModifiedXP(Player player, String string, int n, String string2) {
        ExperienceAPI.addModifiedXP(player, string, n, string2, false);
    }

    public static void addModifiedXP(Player player, String string, int n, String string2, boolean bl) {
        PrimarySkillType primarySkillType = ExperienceAPI.getSkillType(string);
        if (bl) {
            ExperienceAPI.getPlayer(player).beginUnsharedXpGain(primarySkillType, (int)((double)n / primarySkillType.getXpModifier() * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()), ExperienceAPI.getXPGainReason(string2), XPGainSource.CUSTOM);
            return;
        }
        ExperienceAPI.getPlayer(player).applyXpGain(primarySkillType, (int)((double)n / primarySkillType.getXpModifier() * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()), ExperienceAPI.getXPGainReason(string2), XPGainSource.CUSTOM);
    }

    @Deprecated
    public static void addModifiedXPOffline(String string, String string2, int n) {
        PrimarySkillType primarySkillType = ExperienceAPI.getSkillType(string2);
        ExperienceAPI.addOfflineXP(string, primarySkillType, (int)((double)n / primarySkillType.getXpModifier() * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()));
    }

    @Deprecated
    public static void addXP(Player player, String string, int n) {
        ExperienceAPI.addXP(player, string, n, "UNKNOWN");
    }

    public static void addXP(Player player, String string, int n, String string2) {
        ExperienceAPI.addXP(player, string, n, string2, false);
    }

    public static void addXP(Player player, String string, int n, String string2, boolean bl) {
        if (bl) {
            ExperienceAPI.getPlayer(player).beginUnsharedXpGain(ExperienceAPI.getSkillType(string), n, ExperienceAPI.getXPGainReason(string2), XPGainSource.CUSTOM);
            return;
        }
        ExperienceAPI.getPlayer(player).beginXpGain(ExperienceAPI.getSkillType(string), n, ExperienceAPI.getXPGainReason(string2), XPGainSource.CUSTOM);
    }

    public static int getXP(Player player, String string) {
        return ExperienceAPI.getPlayer(player).getSkillXpLevel(ExperienceAPI.getNonChildSkillType(string));
    }

    @Deprecated
    public static int getOfflineXP(String string, String string2) {
        return ExperienceAPI.getOfflineProfile(string).getSkillXpLevel(ExperienceAPI.getNonChildSkillType(string2));
    }

    public static int getOfflineXP(UUID uUID, String string) {
        return ExperienceAPI.getOfflineProfile(uUID).getSkillXpLevel(ExperienceAPI.getNonChildSkillType(string));
    }

    public static float getXPRaw(Player player, String string) {
        return ExperienceAPI.getPlayer(player).getSkillXpLevelRaw(ExperienceAPI.getNonChildSkillType(string));
    }

    @Deprecated
    public static float getOfflineXPRaw(String string, String string2) {
        return ExperienceAPI.getOfflineProfile(string).getSkillXpLevelRaw(ExperienceAPI.getNonChildSkillType(string2));
    }

    public static float getOfflineXPRaw(UUID uUID, String string) {
        return ExperienceAPI.getOfflineProfile(uUID).getSkillXpLevelRaw(ExperienceAPI.getNonChildSkillType(string));
    }

    public static int getXPToNextLevel(Player player, String string) {
        return ExperienceAPI.getPlayer(player).getXpToLevel(ExperienceAPI.getNonChildSkillType(string));
    }

    @Deprecated
    public static int getOfflineXPToNextLevel(String string, String string2) {
        return ExperienceAPI.getOfflineProfile(string).getXpToLevel(ExperienceAPI.getNonChildSkillType(string2));
    }

    public static int getOfflineXPToNextLevel(UUID uUID, String string) {
        return ExperienceAPI.getOfflineProfile(uUID).getXpToLevel(ExperienceAPI.getNonChildSkillType(string));
    }

    public static int getXPRemaining(Player player, String string) {
        PrimarySkillType primarySkillType = ExperienceAPI.getNonChildSkillType(string);
        PlayerProfile playerProfile = ExperienceAPI.getPlayer(player).getProfile();
        return playerProfile.getXpToLevel(primarySkillType) - playerProfile.getSkillXpLevel(primarySkillType);
    }

    @Deprecated
    public static int getOfflineXPRemaining(String string, String string2) {
        PrimarySkillType primarySkillType = ExperienceAPI.getNonChildSkillType(string2);
        PlayerProfile playerProfile = ExperienceAPI.getOfflineProfile(string);
        return playerProfile.getXpToLevel(primarySkillType) - playerProfile.getSkillXpLevel(primarySkillType);
    }

    public static float getOfflineXPRemaining(UUID uUID, String string) {
        PrimarySkillType primarySkillType = ExperienceAPI.getNonChildSkillType(string);
        PlayerProfile playerProfile = ExperienceAPI.getOfflineProfile(uUID);
        return (float)playerProfile.getXpToLevel(primarySkillType) - playerProfile.getSkillXpLevelRaw(primarySkillType);
    }

    public static void addLevel(Player player, String string, int n) {
        ExperienceAPI.getPlayer(player).addLevels(ExperienceAPI.getSkillType(string), n);
    }

    @Deprecated
    public static void addLevelOffline(String string, String string2, int n) {
        PlayerProfile playerProfile = ExperienceAPI.getOfflineProfile(string);
        PrimarySkillType primarySkillType = ExperienceAPI.getSkillType(string2);
        if (primarySkillType.isChildSkill()) {
            Set<PrimarySkillType> set = FamilyTree.getParents(primarySkillType);
            for (PrimarySkillType primarySkillType2 : set) {
                playerProfile.addLevels(primarySkillType2, n / set.size());
            }
            playerProfile.scheduleAsyncSave();
            return;
        }
        playerProfile.addLevels(primarySkillType, n);
        playerProfile.scheduleAsyncSave();
    }

    public static void addLevelOffline(UUID uUID, String string, int n) {
        PlayerProfile playerProfile = ExperienceAPI.getOfflineProfile(uUID);
        PrimarySkillType primarySkillType = ExperienceAPI.getSkillType(string);
        if (primarySkillType.isChildSkill()) {
            Set<PrimarySkillType> set = FamilyTree.getParents(primarySkillType);
            for (PrimarySkillType primarySkillType2 : set) {
                playerProfile.addLevels(primarySkillType2, n / set.size());
            }
            playerProfile.scheduleAsyncSave();
            return;
        }
        playerProfile.addLevels(primarySkillType, n);
        playerProfile.scheduleAsyncSave();
    }

    @Deprecated
    public static int getLevel(Player player, String string) {
        return ExperienceAPI.getPlayer(player).getSkillLevel(ExperienceAPI.getSkillType(string));
    }

    public static int getLevel(Player player, PrimarySkillType primarySkillType) {
        return ExperienceAPI.getPlayer(player).getSkillLevel(primarySkillType);
    }

    @Deprecated
    public static int getLevelOffline(String string, String string2) {
        return ExperienceAPI.getOfflineProfile(string).getSkillLevel(ExperienceAPI.getSkillType(string2));
    }

    public static int getLevelOffline(UUID uUID, String string) {
        return ExperienceAPI.getOfflineProfile(uUID).getSkillLevel(ExperienceAPI.getSkillType(string));
    }

    public static int getPowerLevel(Player player) {
        return ExperienceAPI.getPlayer(player).getPowerLevel();
    }

    @Deprecated
    public static int getPowerLevelOffline(String string) {
        int n = 0;
        PlayerProfile playerProfile = ExperienceAPI.getOfflineProfile(string);
        for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
            n += playerProfile.getSkillLevel(primarySkillType);
        }
        return n;
    }

    public static int getPowerLevelOffline(UUID uUID) {
        int n = 0;
        PlayerProfile playerProfile = ExperienceAPI.getOfflineProfile(uUID);
        for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
            n += playerProfile.getSkillLevel(primarySkillType);
        }
        return n;
    }

    public static int getLevelCap(String string) {
        return Config.getInstance().getLevelCap(ExperienceAPI.getSkillType(string));
    }

    public static int getPowerLevelCap() {
        return Config.getInstance().getPowerLevelCap();
    }

    @Deprecated
    public static int getPlayerRankSkill(String string, String string2) {
        return mcMMO.getDatabaseManager().readRank(mcMMO.p.getServer().getOfflinePlayer(string).getName()).get((Object)ExperienceAPI.getNonChildSkillType(string2));
    }

    public static int getPlayerRankSkill(UUID uUID, String string) {
        return mcMMO.getDatabaseManager().readRank(mcMMO.p.getServer().getOfflinePlayer(uUID).getName()).get((Object)ExperienceAPI.getNonChildSkillType(string));
    }

    @Deprecated
    public static int getPlayerRankOverall(String string) {
        return mcMMO.getDatabaseManager().readRank(mcMMO.p.getServer().getOfflinePlayer(string).getName()).get(null);
    }

    public static int getPlayerRankOverall(UUID uUID) {
        return mcMMO.getDatabaseManager().readRank(mcMMO.p.getServer().getOfflinePlayer(uUID).getName()).get(null);
    }

    public static void setLevel(Player player, String string, int n) {
        ExperienceAPI.getPlayer(player).modifySkill(ExperienceAPI.getSkillType(string), n);
    }

    @Deprecated
    public static void setLevelOffline(String string, String string2, int n) {
        ExperienceAPI.getOfflineProfile(string).modifySkill(ExperienceAPI.getSkillType(string2), n);
    }

    public static void setLevelOffline(UUID uUID, String string, int n) {
        ExperienceAPI.getOfflineProfile(uUID).modifySkill(ExperienceAPI.getSkillType(string), n);
    }

    public static void setXP(Player player, String string, int n) {
        ExperienceAPI.getPlayer(player).setSkillXpLevel(ExperienceAPI.getNonChildSkillType(string), n);
    }

    @Deprecated
    public static void setXPOffline(String string, String string2, int n) {
        ExperienceAPI.getOfflineProfile(string).setSkillXpLevel(ExperienceAPI.getNonChildSkillType(string2), n);
    }

    public static void setXPOffline(UUID uUID, String string, int n) {
        ExperienceAPI.getOfflineProfile(uUID).setSkillXpLevel(ExperienceAPI.getNonChildSkillType(string), n);
    }

    public static void removeXP(Player player, String string, int n) {
        ExperienceAPI.getPlayer(player).removeXp(ExperienceAPI.getNonChildSkillType(string), n);
    }

    @Deprecated
    public static void removeXPOffline(String string, String string2, int n) {
        ExperienceAPI.getOfflineProfile(string).removeXp(ExperienceAPI.getNonChildSkillType(string2), n);
    }

    public static void removeXPOffline(UUID uUID, String string, int n) {
        ExperienceAPI.getOfflineProfile(uUID).removeXp(ExperienceAPI.getNonChildSkillType(string), n);
    }

    public static int getXpNeededToLevel(int n) {
        return mcMMO.getFormulaManager().getXPtoNextLevel(n, ExperienceConfig.getInstance().getFormulaType());
    }

    public static int getXpNeededToLevel(int n, String string) {
        return mcMMO.getFormulaManager().getXPtoNextLevel(n, ExperienceAPI.getFormulaType(string));
    }

    public static void addXpFromBlocks(ArrayList<BlockState> arrayList, McMMOPlayer mcMMOPlayer) {
        for (BlockState blockState : arrayList) {
            for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
                if (ExperienceConfig.getInstance().getXp(primarySkillType, blockState.getType()) <= 0) continue;
                mcMMOPlayer.applyXpGain(primarySkillType, ExperienceConfig.getInstance().getXp(primarySkillType, blockState.getType()), XPGainReason.PVE, XPGainSource.SELF);
            }
        }
    }

    public static void addXpFromBlocksBySkill(ArrayList<BlockState> arrayList, McMMOPlayer mcMMOPlayer, PrimarySkillType primarySkillType) {
        for (BlockState blockState : arrayList) {
            if (ExperienceConfig.getInstance().getXp(primarySkillType, blockState.getType()) <= 0) continue;
            mcMMOPlayer.applyXpGain(primarySkillType, ExperienceConfig.getInstance().getXp(primarySkillType, blockState.getType()), XPGainReason.PVE, XPGainSource.SELF);
        }
    }

    public static void addXpFromBlock(BlockState blockState, McMMOPlayer mcMMOPlayer) {
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            if (ExperienceConfig.getInstance().getXp(primarySkillType, blockState.getType()) <= 0) continue;
            mcMMOPlayer.applyXpGain(primarySkillType, ExperienceConfig.getInstance().getXp(primarySkillType, blockState.getType()), XPGainReason.PVE, XPGainSource.SELF);
        }
    }

    public static void addXpFromBlockBySkill(BlockState blockState, McMMOPlayer mcMMOPlayer, PrimarySkillType primarySkillType) {
        if (ExperienceConfig.getInstance().getXp(primarySkillType, blockState.getType()) > 0) {
            mcMMOPlayer.applyXpGain(primarySkillType, ExperienceConfig.getInstance().getXp(primarySkillType, blockState.getType()), XPGainReason.PVE, XPGainSource.SELF);
        }
    }

    private static void addOfflineXP(UUID uUID, PrimarySkillType primarySkillType, int n) {
        PlayerProfile playerProfile = ExperienceAPI.getOfflineProfile(uUID);
        playerProfile.addXp(primarySkillType, n);
        playerProfile.save(true);
    }

    @Deprecated
    private static void addOfflineXP(String string, PrimarySkillType primarySkillType, int n) {
        PlayerProfile playerProfile = ExperienceAPI.getOfflineProfile(string);
        playerProfile.addXp(primarySkillType, n);
        playerProfile.scheduleAsyncSave();
    }

    private static PlayerProfile getOfflineProfile(UUID uUID) {
        PlayerProfile playerProfile = mcMMO.getDatabaseManager().loadPlayerProfile(uUID);
        if (!playerProfile.isLoaded()) {
            throw new InvalidPlayerException();
        }
        return playerProfile;
    }

    @Deprecated
    private static PlayerProfile getOfflineProfile(String string) {
        UUID uUID = mcMMO.p.getServer().getOfflinePlayer(string).getUniqueId();
        PlayerProfile playerProfile = mcMMO.getDatabaseManager().loadPlayerProfile(uUID);
        if (!playerProfile.isLoaded()) {
            throw new InvalidPlayerException();
        }
        return playerProfile;
    }

    private static PrimarySkillType getSkillType(String string) {
        PrimarySkillType primarySkillType = PrimarySkillType.getSkill(string);
        if (primarySkillType == null) {
            throw new InvalidSkillException();
        }
        return primarySkillType;
    }

    private static PrimarySkillType getNonChildSkillType(String string) {
        PrimarySkillType primarySkillType = ExperienceAPI.getSkillType(string);
        if (primarySkillType.isChildSkill()) {
            throw new UnsupportedOperationException("Child skills do not have XP");
        }
        return primarySkillType;
    }

    private static XPGainReason getXPGainReason(String string) {
        XPGainReason xPGainReason = XPGainReason.getXPGainReason(string);
        if (xPGainReason == null) {
            throw new InvalidXPGainReasonException();
        }
        return xPGainReason;
    }

    private static FormulaType getFormulaType(String string) {
        FormulaType formulaType = FormulaType.getFormulaType(string);
        if (formulaType == null) {
            throw new InvalidFormulaTypeException();
        }
        return formulaType;
    }

    @Deprecated
    private static McMMOPlayer getPlayer(Player player) {
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            throw new McMMOPlayerNotFoundException(player);
        }
        return UserManager.getPlayer(player);
    }
}

