/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.api;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.runnables.skills.BleedTimerTask;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public final class AbilityAPI {
    private AbilityAPI() {
    }

    public static boolean berserkEnabled(Player player) {
        return UserManager.getPlayer(player).getAbilityMode(SuperAbilityType.BERSERK);
    }

    public static boolean gigaDrillBreakerEnabled(Player player) {
        return UserManager.getPlayer(player).getAbilityMode(SuperAbilityType.GIGA_DRILL_BREAKER);
    }

    public static boolean greenTerraEnabled(Player player) {
        return UserManager.getPlayer(player).getAbilityMode(SuperAbilityType.GREEN_TERRA);
    }

    public static boolean serratedStrikesEnabled(Player player) {
        return UserManager.getPlayer(player).getAbilityMode(SuperAbilityType.SERRATED_STRIKES);
    }

    public static boolean skullSplitterEnabled(Player player) {
        return UserManager.getPlayer(player).getAbilityMode(SuperAbilityType.SKULL_SPLITTER);
    }

    public static boolean superBreakerEnabled(Player player) {
        return UserManager.getPlayer(player).getAbilityMode(SuperAbilityType.SUPER_BREAKER);
    }

    public static boolean treeFellerEnabled(Player player) {
        return UserManager.getPlayer(player).getAbilityMode(SuperAbilityType.TREE_FELLER);
    }

    public static boolean isAnyAbilityEnabled(Player player) {
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        for (SuperAbilityType superAbilityType : SuperAbilityType.values()) {
            if (!mcMMOPlayer.getAbilityMode(superAbilityType)) continue;
            return true;
        }
        return false;
    }

    public static void resetCooldowns(Player player) {
        UserManager.getPlayer(player).resetCooldowns();
    }

    public static void setBerserkCooldown(Player player, long l) {
        UserManager.getPlayer(player).setAbilityDATS(SuperAbilityType.BERSERK, l);
    }

    public static void setGigaDrillBreakerCooldown(Player player, long l) {
        UserManager.getPlayer(player).setAbilityDATS(SuperAbilityType.GIGA_DRILL_BREAKER, l);
    }

    public static void setGreenTerraCooldown(Player player, long l) {
        UserManager.getPlayer(player).setAbilityDATS(SuperAbilityType.GREEN_TERRA, l);
    }

    public static void setSerratedStrikesCooldown(Player player, long l) {
        UserManager.getPlayer(player).setAbilityDATS(SuperAbilityType.SERRATED_STRIKES, l);
    }

    public static void setSkullSplitterCooldown(Player player, long l) {
        UserManager.getPlayer(player).setAbilityDATS(SuperAbilityType.SKULL_SPLITTER, l);
    }

    public static void setSuperBreakerCooldown(Player player, long l) {
        UserManager.getPlayer(player).setAbilityDATS(SuperAbilityType.SUPER_BREAKER, l);
    }

    public static void setTreeFellerCooldown(Player player, long l) {
        UserManager.getPlayer(player).setAbilityDATS(SuperAbilityType.TREE_FELLER, l);
    }

    public static boolean isBleeding(LivingEntity livingEntity) {
        return BleedTimerTask.isBleeding(livingEntity);
    }
}

