/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.managers.index;

import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.protection.managers.index.HashMapIndex;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegionMBRConverter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.khelekore.prtree.MBR;
import org.khelekore.prtree.MBRConverter;
import org.khelekore.prtree.PRTree;
import org.khelekore.prtree.SimpleMBR;

public class PriorityRTreeIndex
extends HashMapIndex {
    private static final int BRANCH_FACTOR = 30;
    private static final MBRConverter<ProtectedRegion> CONVERTER = new ProtectedRegionMBRConverter();
    private PRTree<ProtectedRegion> tree = new PRTree(CONVERTER, 30);

    public PriorityRTreeIndex() {
        this.tree.load(Collections.emptyList());
    }

    @Override
    protected void rebuildIndex() {
        PRTree newTree = new PRTree(CONVERTER, 30);
        newTree.load(this.values());
        this.tree = newTree;
    }

    @Override
    public void applyContaining(BlockVector3 position, Predicate<ProtectedRegion> consumer) {
        HashSet<ProtectedRegion> seen = new HashSet<ProtectedRegion>();
        SimpleMBR pointMBR = new SimpleMBR(new double[]{position.getX(), position.getX(), position.getY(), position.getY(), position.getZ(), position.getZ()});
        for (ProtectedRegion region : this.tree.find((MBR)pointMBR)) {
            if (!region.contains(position) || seen.contains(region)) continue;
            seen.add(region);
            if (consumer.test(region)) continue;
            break;
        }
    }

    @Override
    public void applyIntersecting(ProtectedRegion region, Predicate<ProtectedRegion> consumer) {
        ProtectedRegion found2;
        BlockVector3 min = region.getMinimumPoint().floor();
        BlockVector3 max = region.getMaximumPoint().ceil();
        HashSet<ProtectedRegion> candidates = new HashSet<ProtectedRegion>();
        SimpleMBR pointMBR = new SimpleMBR(new double[]{min.getX(), max.getX(), min.getY(), max.getY(), min.getZ(), max.getZ()});
        for (ProtectedRegion found2 : this.tree.find((MBR)pointMBR)) {
            candidates.add(found2);
        }
        Iterator<Object> iterator = region.getIntersectingRegions(candidates).iterator();
        while (iterator.hasNext() && consumer.test(found2 = (ProtectedRegion)iterator.next())) {
        }
    }

    public static final class Factory
    implements Function<String, PriorityRTreeIndex> {
        @Override
        public PriorityRTreeIndex apply(String name) {
            return new PriorityRTreeIndex();
        }
    }
}

