/*
 * Decompiled with CFR 0.152.
 */
package to.hc.common.core.collect;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nullable;

public class Pair<L, R> {
    private final L left;
    private final R right;

    public Pair(@Nullable L left, @Nullable R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Pair that = (Pair)other;
        return Objects.equal(this.left, that.left) && Objects.equal(this.right, that.right);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.left, this.right});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("a", this.left).add("b", this.right).toString();
    }

    public static <L, R> Pair<L, R> of(@Nullable L left, @Nullable R right) {
        return new Pair<L, R>(left, right);
    }
}

