/*
 * Decompiled with CFR 0.152.
 */
package to.hc.common.bukkit.ui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import to.hc.common.bukkit.ui.ActionBar;

public final class UIManager
implements Listener {
    protected final BiMap<UUID, ActionBar> actionBarMap = HashBiMap.create();

    public ActionBar getActionBar(Player player) {
        ActionBar bar = (ActionBar)this.actionBarMap.get((Object)player.getUniqueId());
        if (bar == null) {
            bar = new ActionBar(player);
            this.actionBarMap.put((Object)player.getUniqueId(), (Object)bar);
        }
        return bar;
    }

    public void disable() {
        this.actionBarMap.values().forEach(ActionBar::destroy);
        this.actionBarMap.clear();
    }

    @EventHandler
    public void playerKick(PlayerKickEvent event) {
        this.cleanPlayer(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void playerQuit(PlayerQuitEvent event) {
        this.cleanPlayer(event.getPlayer().getUniqueId());
    }

    private void cleanPlayer(UUID uniqueId) {
        ActionBar bar = (ActionBar)this.actionBarMap.get((Object)uniqueId);
        if (bar != null) {
            bar.destroy();
        }
        this.actionBarMap.inverse().remove((Object)bar);
    }
}

