/*
 * Decompiled with CFR 0.152.
 */
package to.hc.common.bukkit.ui;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.herocraftonline.heroes.Heroes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import to.hc.common.bukkit.util.NMSHacks;

public class ManagedScoreboard
implements Runnable {
    public static final String IDENTIFIER = "commons";
    public static final int MAX_ROWS = 16;
    public static final int MAX_PREFIX_SUFFIX = 16;
    private Player player;
    private final Scoreboard scoreboard;
    private final Objective objective;
    private final String[] rows = new String[16];
    private final Team[] teams = new Team[16];
    private final String[] players = new String[16];
    private BukkitTask task;
    private final List<Component> components = Lists.newLinkedList();

    public ManagedScoreboard(Player player) {
        this.player = player;
        this.scoreboard = this.player.getServer().getScoreboardManager().getNewScoreboard();
        this.objective = this.scoreboard.registerNewObjective(IDENTIFIER, IDENTIFIER, IDENTIFIER);
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        for (int i = 0; i < 16; ++i) {
            this.rows[i] = null;
            this.teams[i] = this.scoreboard.registerNewTeam("commons-r-" + i);
            this.players[i] = ManagedScoreboard.createPlayer(i);
            this.teams[i].addEntry(this.players[i]);
            this.teams[i].setPrefix("");
            this.teams[i].setSuffix("");
        }
        this.player.setScoreboard(this.scoreboard);
    }

    @Override
    public void run() {
        this.render();
    }

    public void render() {
        if (this.components.size() == 0) {
            this.stop();
            return;
        }
        ArrayList rows = Lists.newArrayListWithCapacity((int)16);
        for (Component component : this.components) {
            component.render(this.player, rows);
        }
        for (int i = 0; i < 16; ++i) {
            if (i < rows.size()) {
                this.setRow(i, (String)rows.get(rows.size() - i - 1));
                continue;
            }
            this.setRow(i, null);
        }
    }

    public void start() {
        if (this.task == null) {
            this.clear();
            this.task = Heroes.getInstance().getServer().getScheduler().runTaskTimer((Plugin)Heroes.getInstance(), (Runnable)this, 20L, 20L);
        }
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.clear();
            this.task = null;
        }
    }

    private void setRow(int row, String text) {
        if (row < 0 || row >= 16 || Objects.equal((Object)this.rows[row], (Object)text)) {
            return;
        }
        this.rows[row] = text;
        if (text == null) {
            this.scoreboard.resetScores(this.players[row]);
            this.teams[row].removeEntry(this.players[row]);
            this.players[row] = ManagedScoreboard.createPlayer(row);
            this.teams[row].addEntry(this.players[row]);
        } else {
            this.scoreboard.resetScores(this.players[row]);
            this.teams[row].removeEntry(this.players[row]);
            String[] parts = ManagedScoreboard.split(text);
            this.teams[row].setPrefix(parts[0]);
            this.players[row] = parts[1];
            this.teams[row].addEntry(this.players[row]);
            this.teams[row].setSuffix(parts[2]);
            try {
                this.objective.getScore(this.players[row]).setScore(row + 1);
            }
            catch (IllegalArgumentException e) {
                String trucated = this.players[row].substring(0, 16);
                this.objective.getScore(trucated).setScore(row + 1);
            }
        }
    }

    private static String[] split(String string) {
        int maxNameLength = NMSHacks.getMaxScoreboardEntryNameLength();
        if (string.length() <= maxNameLength) {
            return new String[]{"", string, ""};
        }
        String[] result = new String[3];
        int split = 15;
        if (string.length() < 16 || string.charAt(split) != '\u00a7') {
            ++split;
        }
        result[0] = StringUtils.substring((String)string, (int)0, (int)split);
        String lastColors = ChatColor.getLastColors((String)result[0]);
        result[1] = lastColors + StringUtils.substring((String)string, (int)split, (int)(maxNameLength - lastColors.length()));
        lastColors = ChatColor.getLastColors((String)result[1]);
        result[2] = lastColors + StringUtils.substring((String)string, (int)(maxNameLength - lastColors.length()), (int)(maxNameLength - lastColors.length() + 16));
        return result;
    }

    public void clear() {
        for (int i = 0; i < 16; ++i) {
            this.rows[i] = null;
            this.teams[i].setPrefix("");
            this.teams[i].setSuffix("");
            this.scoreboard.resetScores(this.players[i]);
        }
    }

    public ManagedScoreboard setDisplayName(String string) {
        this.objective.setDisplayName(string);
        return this;
    }

    public List<Component> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public boolean hasComponent(Component component) {
        return this.components.contains(component);
    }

    public boolean removeComponent(Component component) {
        return this.components.remove(component);
    }

    public void addComponent(Component component) {
        if (component.isEnabled()) {
            this.components.add(component);
        }
    }

    public void clearComponents() {
        this.components.clear();
    }

    public boolean toggleComponent(Component component) {
        if (!component.isEnabled()) {
            return false;
        }
        this.clear();
        boolean contains = this.components.contains(component);
        if (contains) {
            this.components.remove(component);
            return false;
        }
        this.components.add(component);
        return true;
    }

    public void destroy() {
        this.stop();
        this.player = null;
    }

    private static String createPlayer(int row) {
        return String.valueOf('\u00a7') + (char)row;
    }

    public static interface Component {
        public void render(Player var1, List<String> var2);

        public String getName();

        public boolean isEnabled();
    }
}

