/*
 * Decompiled with CFR 0.152.
 */
package to.hc.common.bukkit.ui;

import com.google.common.collect.Lists;
import com.herocraftonline.heroes.Heroes;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import to.hc.common.bukkit.util.NMSHacks;

public class ActionBar
implements Runnable {
    private Player player;
    private final List<ActionBarComponent> components = Lists.newLinkedList();
    private ActionBarComponent current;
    private int index = -1;
    private long count = 0L;
    private BukkitTask task;
    private boolean visible = true;

    protected ActionBar(Player player) {
        this.player = player;
    }

    @Override
    public void run() {
        this.render();
    }

    public void render() {
        if (this.components.isEmpty()) {
            this.stop();
            return;
        }
        if (this.components.size() != 1) {
            ++this.index;
            if (this.index >= this.components.size()) {
                this.index = 0;
            }
            ++this.count;
            if (this.count >= (long)this.current.length()) {
                this.count = 0L;
                this.current = this.components.get(this.index);
            }
        } else {
            this.current = this.components.get(0);
        }
        if (!this.visible && !this.current.canOverridePlayer()) {
            this.stop();
            return;
        }
        this.start();
        if (this.player == null || this.current == null) {
            this.stop();
        } else {
            String result = this.current.render(this.player, this);
            if (result != null) {
                NMSHacks.sendActionBar(this.player, result);
            }
        }
    }

    public void start() {
        if (this.task == null) {
            this.task = Heroes.getInstance().getServer().getScheduler().runTaskTimer((Plugin)Heroes.getInstance(), (Runnable)this, 1L, 20L);
        }
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    public void destroy() {
        this.stop();
        this.player = null;
    }

    public ActionBarComponent getCurrent() {
        return this.current;
    }

    public List<ActionBarComponent> get() {
        return this.components;
    }

    public void add(ActionBarComponent component) {
        this.components.add(component);
        this.render();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public static interface ActionBarComponent {
        public String render(Player var1, ActionBar var2);

        public String getName();

        public boolean canOverridePlayer();

        public int length();
    }
}

