/*
 * Decompiled with CFR 0.152.
 */
package to.hc.common.bukkit.pagination;

import com.google.common.base.Strings;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import to.hc.common.bukkit.chat.ChatSendResult;
import to.hc.common.bukkit.chat.ChatUtil;
import to.hc.common.bukkit.pagination.PaginationUtil;
import to.hc.common.bukkit.util.NMSHacks;
import to.hc.common.core.collect.Pair;

public abstract class PaginatedResult<T> {
    private final int resultsPerPage;
    private final String header;
    protected final String pageCommand;

    public PaginatedResult(String header, String pageCommand) {
        this(header, pageCommand, 6);
    }

    public PaginatedResult(String header, String pageCommand, int resultsPerPage) {
        this.header = header;
        this.pageCommand = pageCommand;
        this.resultsPerPage = resultsPerPage;
    }

    public void display(CommandSender viewer, List<? extends T> results, int page) {
        if (results.size() == 0) {
            viewer.sendMessage(ChatColor.GRAY + "No results match.");
            return;
        }
        int maxPages = results.size() / this.resultsPerPage + 1;
        if (results.size() % this.resultsPerPage == 0) {
            --maxPages;
        }
        if (page <= 0 || page > maxPages) {
            viewer.sendMessage(ChatColor.GRAY + "Unknown page selected. " + maxPages + " total pages.");
            return;
        }
        Pair<BaseComponent[], String> header = this.buildHeader(page, maxPages);
        ChatSendResult chatSendResult = NMSHacks.sendMessage(viewer, header.getLeft(), header.getRight());
        for (int i = this.resultsPerPage * (page - 1); i < this.resultsPerPage * page && i < results.size(); ++i) {
            chatSendResult = NMSHacks.sendMessage(viewer, this.build(results.get(i), i), this.buildFallback(results.get(i), i));
        }
        Pair<BaseComponent[], String> footer = this.buildFooter(page, maxPages);
        if (footer != null) {
            chatSendResult = NMSHacks.sendMessage(viewer, footer.getLeft(), footer.getRight());
        }
        this.after(viewer, chatSendResult);
    }

    public Pair<BaseComponent[], String> buildHeader(int page, int maxPages) {
        String dash = "-";
        String header = " " + this.header + " ";
        int paginationLength = ("(" + page + "/" + maxPages + ")").length();
        String dashes = Strings.repeat((String)"-", (int)((55 - ChatColor.stripColor((String)header).length() - 2 - paginationLength) / ("-".length() * 2)));
        return Pair.of(new ComponentBuilder(dashes).color(ChatUtil.toBungee(ChatColor.DARK_GRAY)).append(header).color(ChatUtil.toBungee(ChatColor.RESET)).append("(").color(ChatUtil.toBungee(ChatColor.GRAY)).append(String.valueOf(page)).color(ChatUtil.toBungee(ChatColor.WHITE)).append("/").color(ChatUtil.toBungee(ChatColor.GRAY)).append(String.valueOf(maxPages)).color(ChatUtil.toBungee(ChatColor.WHITE)).append(") ").color(ChatUtil.toBungee(ChatColor.GRAY)).append(dashes).color(ChatUtil.toBungee(ChatColor.DARK_GRAY)).create(), ChatUtil.dashedChatMessage(this.header + ChatColor.GRAY + "(" + ChatColor.WHITE + page + ChatColor.GRAY + "/" + ChatColor.WHITE + maxPages + ChatColor.GRAY + ") ", "-", ChatColor.DARK_GRAY));
    }

    public Pair<BaseComponent[], String> buildFooter(int page, int maxPages) {
        if (page == 1 && page == maxPages) {
            return PaginationUtil.EMPTY_FOOTER;
        }
        boolean hasPreviousPage = page > 1 && maxPages > 1;
        boolean hasNextPage = page < maxPages && page == 1 || hasPreviousPage && page > 1 && page != maxPages;
        return new Pair<BaseComponent[], String>(this.buildFooterComponents(page, maxPages, hasPreviousPage, hasNextPage), PaginationUtil.FULL_DASHED_STRING);
    }

    private BaseComponent[] buildFooterComponents(int page, int maxPages, boolean hasPreviousPage, boolean hasNextPage) {
        ComponentBuilder builder = hasNextPage && hasPreviousPage ? new ComponentBuilder("--------------------").color(ChatUtil.toBungee(ChatColor.DARK_GRAY)) : new ComponentBuilder("--------------------------").color(ChatUtil.toBungee(ChatColor.DARK_GRAY));
        if (hasPreviousPage) {
            builder.append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, this.buildPageCommand(page - 1))).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Previous Page").color(ChatUtil.toBungee(ChatColor.RED)).create())).append("\u00ab").color(ChatUtil.toBungee(ChatColor.RED)).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).append("").event((ClickEvent)null).event((HoverEvent)null);
            if (hasNextPage) {
                builder.append("--------").color(ChatUtil.toBungee(ChatColor.DARK_GRAY));
            }
        }
        if (hasNextPage) {
            builder.append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, this.buildPageCommand(page + 1))).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Next Page").color(ChatUtil.toBungee(ChatColor.GREEN)).create())).append("\u00bb").color(ChatUtil.toBungee(ChatColor.GREEN)).append("]").color(ChatUtil.toBungee(ChatColor.WHITE));
        }
        if (hasNextPage && hasPreviousPage) {
            builder.append("--------------------");
        } else {
            builder.append("-------------------------");
        }
        builder.color(ChatUtil.toBungee(ChatColor.DARK_GRAY)).event((ClickEvent)null).event((HoverEvent)null);
        return builder.create();
    }

    public String buildPageCommand(int page) {
        return this.pageCommand.replace("{INDEX}", String.valueOf(page));
    }

    protected abstract BaseComponent[] build(T var1, int var2);

    protected abstract String buildFallback(T var1, int var2);

    protected void after(CommandSender viewer, ChatSendResult chatSendResult) {
    }
}

