/*
 * Decompiled with CFR 0.152.
 */
package to.hc.common.bukkit.compat;

import com.google.common.base.Preconditions;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import to.hc.common.bukkit.CraftAttribute;
import to.hc.common.bukkit.chat.ChatSendResult;
import to.hc.common.bukkit.chat.json.ComponentSerializer;
import to.hc.common.bukkit.compat.ModernCompatBase;

public final class Compat_vLATEST
extends ModernCompatBase {
    @Override
    public ChatSendResult sendMessage(CommandSender viewer, BaseComponent component) {
        if (viewer instanceof Player) {
            ((Player)viewer).spigot().sendMessage(component);
            return ChatSendResult.COMPONENT;
        }
        viewer.sendMessage(component.toLegacyText());
        return ChatSendResult.COMPONENT;
    }

    @Override
    public ChatSendResult sendMessage(CommandSender viewer, BaseComponent component, String fallback) {
        if (viewer instanceof Player) {
            ((Player)viewer).spigot().sendMessage(component);
            return ChatSendResult.COMPONENT;
        }
        if (fallback == null) {
            return ChatSendResult.FAIL;
        }
        viewer.sendMessage(fallback);
        return ChatSendResult.FALLBACK;
    }

    @Override
    public ChatSendResult sendMessage(CommandSender viewer, BaseComponent[] components) {
        if (viewer instanceof Player) {
            ((Player)viewer).spigot().sendMessage(components);
            return ChatSendResult.COMPONENT;
        }
        for (BaseComponent component : components) {
            viewer.sendMessage(component.toLegacyText());
        }
        return ChatSendResult.COMPONENT;
    }

    @Override
    public ChatSendResult sendMessage(CommandSender viewer, BaseComponent[] components, String fallback) {
        if (viewer instanceof Player) {
            ((Player)viewer).spigot().sendMessage(components);
            return ChatSendResult.COMPONENT;
        }
        if (fallback == null) {
            return ChatSendResult.FAIL;
        }
        viewer.sendMessage(fallback);
        return ChatSendResult.FALLBACK;
    }

    @Override
    public ChatSendResult sendMessageAsMinecraft(CommandSender viewer, BaseComponent[] components) {
        if (viewer instanceof Player) {
            ((Player)viewer).spigot().sendMessage(ChatMessageType.CHAT, (BaseComponent)new TextComponent(ComponentSerializer.serialize(components)));
            return ChatSendResult.COMPONENT;
        }
        for (BaseComponent component : components) {
            viewer.sendMessage(component.toLegacyText());
        }
        return ChatSendResult.COMPONENT;
    }

    @Override
    public void sendActionBar(Player viewer, String string) {
        viewer.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(string));
    }

    @Override
    public void setAttributeValue(LivingEntity entity, CraftAttribute attribute, double value) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity");
        Preconditions.checkNotNull((Object)((Object)attribute), (Object)"attribute");
        Attribute attributeInstance = Compat_vLATEST.attributeFor(attribute);
        if (attributeInstance != null) {
            entity.getAttribute(attributeInstance).setBaseValue(value);
        }
    }

    @Override
    public ChatColor getItemStackRarityColor(ItemStack stack) {
        ChatColor color = ChatColor.WHITE;
        if (stack.hasItemMeta() && stack.getItemMeta().hasDisplayName()) {
            color = ChatColor.getByChar((String)ChatColor.getLastColors((String)stack.getItemMeta().getDisplayName()));
        }
        return color;
    }

    @Override
    @Deprecated
    public String getItemStackCompoundTagAsString(ItemStack stack) {
        return "";
    }

    private static Attribute attributeFor(CraftAttribute attribute) {
        switch (attribute) {
            case MAX_HEALTH: {
                return Attribute.GENERIC_MAX_HEALTH;
            }
            case FOLLOW_RANGE: {
                return Attribute.GENERIC_FOLLOW_RANGE;
            }
            case KNOCKBACK_RESISTANCE: {
                return Attribute.GENERIC_KNOCKBACK_RESISTANCE;
            }
            case MOVEMENT_SPEED: {
                return Attribute.GENERIC_MOVEMENT_SPEED;
            }
            case ATTACK_DAMAGE: {
                return Attribute.GENERIC_ATTACK_DAMAGE;
            }
        }
        return null;
    }
}

