/*
 * Decompiled with CFR 0.152.
 */
package to.hc.common.bukkit.compat;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.server.v1_13_R2.AttributeInstance;
import net.minecraft.server.v1_13_R2.ChatMessageType;
import net.minecraft.server.v1_13_R2.EnumChatFormat;
import net.minecraft.server.v1_13_R2.GenericAttributes;
import net.minecraft.server.v1_13_R2.IAttribute;
import net.minecraft.server.v1_13_R2.IChatBaseComponent;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import net.minecraft.server.v1_13_R2.Packet;
import net.minecraft.server.v1_13_R2.PacketPlayOutChat;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import to.hc.common.bukkit.CraftAttribute;
import to.hc.common.bukkit.chat.ChatSendResult;
import to.hc.common.bukkit.chat.json.ComponentSerializer;
import to.hc.common.bukkit.compat.ModernCompatBase;

public final class Compat_v1_13_R1
extends ModernCompatBase {
    private final BiMap<EnumChatFormat, ChatColor> minecraftToBukkitColorMap = ImmutableBiMap.builder().put((Object)EnumChatFormat.BLACK, (Object)ChatColor.BLACK).put((Object)EnumChatFormat.DARK_BLUE, (Object)ChatColor.DARK_BLUE).put((Object)EnumChatFormat.DARK_GREEN, (Object)ChatColor.DARK_GREEN).put((Object)EnumChatFormat.DARK_AQUA, (Object)ChatColor.DARK_AQUA).put((Object)EnumChatFormat.DARK_RED, (Object)ChatColor.DARK_RED).put((Object)EnumChatFormat.DARK_PURPLE, (Object)ChatColor.DARK_PURPLE).put((Object)EnumChatFormat.GOLD, (Object)ChatColor.GOLD).put((Object)EnumChatFormat.GRAY, (Object)ChatColor.GRAY).put((Object)EnumChatFormat.DARK_GRAY, (Object)ChatColor.DARK_GRAY).put((Object)EnumChatFormat.BLUE, (Object)ChatColor.BLUE).put((Object)EnumChatFormat.GREEN, (Object)ChatColor.GREEN).put((Object)EnumChatFormat.AQUA, (Object)ChatColor.AQUA).put((Object)EnumChatFormat.RED, (Object)ChatColor.RED).put((Object)EnumChatFormat.LIGHT_PURPLE, (Object)ChatColor.LIGHT_PURPLE).put((Object)EnumChatFormat.YELLOW, (Object)ChatColor.YELLOW).put((Object)EnumChatFormat.WHITE, (Object)ChatColor.WHITE).put((Object)EnumChatFormat.OBFUSCATED, (Object)ChatColor.MAGIC).put((Object)EnumChatFormat.BOLD, (Object)ChatColor.BOLD).put((Object)EnumChatFormat.STRIKETHROUGH, (Object)ChatColor.STRIKETHROUGH).put((Object)EnumChatFormat.UNDERLINE, (Object)ChatColor.UNDERLINE).put((Object)EnumChatFormat.ITALIC, (Object)ChatColor.ITALIC).put((Object)EnumChatFormat.RESET, (Object)ChatColor.RESET).build();

    @Override
    public ChatSendResult sendMessage(CommandSender viewer, BaseComponent component) {
        if (viewer instanceof Player) {
            ((Player)viewer).spigot().sendMessage(component);
            return ChatSendResult.COMPONENT;
        }
        viewer.sendMessage(component.toLegacyText());
        return ChatSendResult.COMPONENT;
    }

    @Override
    public ChatSendResult sendMessage(CommandSender viewer, BaseComponent component, String fallback) {
        if (viewer instanceof Player) {
            ((Player)viewer).spigot().sendMessage(component);
            return ChatSendResult.COMPONENT;
        }
        if (fallback == null) {
            return ChatSendResult.FAIL;
        }
        viewer.sendMessage(fallback);
        return ChatSendResult.FALLBACK;
    }

    @Override
    public ChatSendResult sendMessage(CommandSender viewer, BaseComponent[] components) {
        if (viewer instanceof Player) {
            ((Player)viewer).spigot().sendMessage(components);
            return ChatSendResult.COMPONENT;
        }
        for (BaseComponent component : components) {
            viewer.sendMessage(component.toLegacyText());
        }
        return ChatSendResult.COMPONENT;
    }

    @Override
    public ChatSendResult sendMessage(CommandSender viewer, BaseComponent[] components, String fallback) {
        if (viewer instanceof Player) {
            ((Player)viewer).spigot().sendMessage(components);
            return ChatSendResult.COMPONENT;
        }
        if (fallback == null) {
            return ChatSendResult.FAIL;
        }
        viewer.sendMessage(fallback);
        return ChatSendResult.FALLBACK;
    }

    @Override
    public ChatSendResult sendMessageAsMinecraft(CommandSender viewer, BaseComponent[] components) {
        if (viewer instanceof Player) {
            ((CraftPlayer)viewer).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutChat(IChatBaseComponent.ChatSerializer.a((String)ComponentSerializer.serialize(components))));
            return ChatSendResult.COMPONENT;
        }
        for (BaseComponent component : components) {
            viewer.sendMessage(component.toLegacyText());
        }
        return ChatSendResult.COMPONENT;
    }

    @Override
    public void sendActionBar(Player viewer, String string) {
        ((CraftPlayer)viewer).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutChat(IChatBaseComponent.ChatSerializer.a((String)("{\"text\": \"" + string + "\"}")), ChatMessageType.GAME_INFO));
    }

    @Override
    public void setAttributeValue(LivingEntity entity, CraftAttribute attribute, double value) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity");
        Preconditions.checkNotNull((Object)((Object)attribute), (Object)"attribute");
        AttributeInstance attributeInstance = ((CraftLivingEntity)entity).getHandle().getAttributeInstance((IAttribute)Preconditions.checkNotNull((Object)Compat_v1_13_R1.attributeFor(attribute), (Object)"mc attribute"));
        if (attributeInstance != null) {
            attributeInstance.setValue(value);
        }
    }

    private <T> ChatColor getMinecraftColorAsBukkit(T color) {
        return (ChatColor)this.minecraftToBukkitColorMap.get(color);
    }

    @Override
    public ChatColor getItemStackRarityColor(ItemStack stack) {
        return this.getMinecraftColorAsBukkit(CraftItemStack.asNMSCopy((ItemStack)stack).u().e);
    }

    @Override
    public String getItemStackCompoundTagAsString(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        CraftItemStack.asNMSCopy((ItemStack)stack).save(compound);
        return compound.toString();
    }

    private static IAttribute attributeFor(CraftAttribute attribute) {
        switch (attribute) {
            case MAX_HEALTH: {
                return GenericAttributes.maxHealth;
            }
            case FOLLOW_RANGE: {
                return GenericAttributes.FOLLOW_RANGE;
            }
            case KNOCKBACK_RESISTANCE: {
                return GenericAttributes.c;
            }
            case MOVEMENT_SPEED: {
                return GenericAttributes.MOVEMENT_SPEED;
            }
            case ATTACK_DAMAGE: {
                return GenericAttributes.ATTACK_DAMAGE;
            }
        }
        return null;
    }
}

