/*
 * Decompiled with CFR 0.152.
 */
package to.hc.common.bukkit.chat.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import to.hc.common.bukkit.chat.json.TextComponentSerializer;
import to.hc.common.bukkit.chat.json.TranslatableComponentSerializer;

public final class ComponentSerializer
implements JsonSerializer<BaseComponent> {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BaseComponent.class, (Object)new ComponentSerializer()).registerTypeAdapter(TextComponent.class, (Object)new TextComponentSerializer()).registerTypeAdapter(TranslatableComponent.class, (Object)new TranslatableComponentSerializer()).create();
    static final ThreadLocal<Set<BaseComponent>> COMPONENT_CACHE = new ThreadLocal();

    public static String serialize(BaseComponent[] components) {
        return GSON.toJson((Object)new TextComponent(components));
    }

    public JsonElement serialize(BaseComponent component, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        ComponentSerializer.serialize(object, component, context);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void serialize(JsonObject object, BaseComponent component, JsonSerializationContext context) {
        boolean first = false;
        if (COMPONENT_CACHE.get() == null) {
            first = true;
            COMPONENT_CACHE.set(Sets.newHashSet());
        }
        try {
            JsonObject event;
            Preconditions.checkArgument((!COMPONENT_CACHE.get().contains(component) ? 1 : 0) != 0, (Object)"Component loop");
            COMPONENT_CACHE.get().add(component);
            if (component.getColorRaw() != null) {
                object.addProperty("color", component.getColorRaw().getName());
            }
            if (component.isBoldRaw() != null) {
                object.addProperty("bold", component.isBoldRaw());
            }
            if (component.isItalicRaw() != null) {
                object.addProperty("italic", component.isItalicRaw());
            }
            if (component.isUnderlinedRaw() != null) {
                object.addProperty("underlined", component.isUnderlinedRaw());
            }
            if (component.isStrikethroughRaw() != null) {
                object.addProperty("strikethrough", component.isStrikethroughRaw());
            }
            if (component.isObfuscatedRaw() != null) {
                object.addProperty("obfuscated", component.isObfuscatedRaw());
            }
            if (component.getExtra() != null) {
                object.add("extra", context.serialize((Object)component.getExtra()));
            }
            if (component.getClickEvent() != null) {
                event = new JsonObject();
                event.addProperty("action", component.getClickEvent().getAction().toString().toLowerCase());
                event.addProperty("value", component.getClickEvent().getValue());
                object.add("clickEvent", (JsonElement)event);
            }
            if (component.getHoverEvent() != null) {
                event = new JsonObject();
                event.addProperty("action", component.getHoverEvent().getAction().toString().toLowerCase());
                event.add("value", context.serialize((Object)component.getHoverEvent().getValue()[0]));
                object.add("hoverEvent", (JsonElement)event);
            }
        }
        finally {
            COMPONENT_CACHE.get().remove(component);
            if (first) {
                COMPONENT_CACHE.set(null);
            }
        }
    }
}

