/*
 * Decompiled with CFR 0.152.
 */
package to.hc.common.bukkit.chat;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.BaseComponent;
import to.hc.common.bukkit.chat.Title;

public class TitleBuilder {
    private static final int DEFAULT_TICKS_FADE_IN = 20;
    private static final int DEFAULT_TICKS_STAY = 60;
    private static final int DEFAULT_TICKS_FADE_OUT = 20;
    private static Class<? extends Title> titleClass;
    private static Constructor<? extends Title> titleConstructor;
    private boolean hide;
    private boolean reset;
    private int fadeInTicks = 20;
    private int stayTicks = 60;
    private int fadeOutTicks = 20;
    private boolean timesChanged = false;
    private BaseComponent[] subtitle;
    private BaseComponent[] title;

    public static TitleBuilder start() {
        return new TitleBuilder();
    }

    private TitleBuilder() {
    }

    public TitleBuilder times(int fadeInTicks, int stayTicks, int fadeOutTicks) {
        if (fadeInTicks == -1 && stayTicks == -1 && fadeOutTicks == -1) {
            this.timesChanged = false;
        } else {
            this.fadeInTicks = fadeInTicks;
            this.stayTicks = stayTicks;
            this.fadeOutTicks = fadeOutTicks;
            this.timesChanged = true;
        }
        return this;
    }

    public TitleBuilder defaultTimes() {
        return this.times(20, 60, 20);
    }

    public TitleBuilder subtitle(BaseComponent[] subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public TitleBuilder subtitle(BaseComponent subtitle) {
        this.subtitle = new BaseComponent[]{subtitle};
        return this;
    }

    public TitleBuilder title(BaseComponent[] title) {
        this.title = title;
        return this;
    }

    public TitleBuilder title(BaseComponent title) {
        this.title = new BaseComponent[]{title};
        return this;
    }

    public TitleBuilder hide() {
        this.hide = true;
        return this;
    }

    public TitleBuilder reset() {
        this.reset = true;
        return this;
    }

    @Nullable
    public Title build() {
        try {
            if (titleConstructor == null) {
                titleConstructor = titleClass.getDeclaredConstructor(Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, BaseComponent[].class, BaseComponent[].class);
                titleConstructor.setAccessible(true);
            }
            return titleConstructor.newInstance(this.hide, this.reset, this.fadeInTicks, this.stayTicks, this.fadeOutTicks, this.timesChanged, this.subtitle, this.title);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

