/*
 * Decompiled with CFR 0.152.
 */
package to.hc.common.bukkit.callback;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Maps;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import to.hc.common.bukkit.callback.Callback;

public final class CallbackRegistry {
    private static CallbackRegistry self = new CallbackRegistry();
    private final LoadingCache<Callback, UUID> cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<Callback, UUID>(){

        public void onRemoval(@Nonnull RemovalNotification<Callback, UUID> notification) {
            CallbackRegistry.this.inverseCache.remove(notification.getValue(), notification.getKey());
        }
    }).build((CacheLoader)new CacheLoader<Callback, UUID>(){

        public UUID load(@Nonnull Callback callback) throws Exception {
            UUID uniqueId = UUID.randomUUID();
            callback.setUniqueId(uniqueId);
            CallbackRegistry.this.inverseCache.putIfAbsent(uniqueId, callback);
            return uniqueId;
        }
    });
    private final ConcurrentMap<UUID, Callback> inverseCache = Maps.newConcurrentMap();

    public static CallbackRegistry get() {
        return self;
    }

    @Nonnull
    public UUID create(@Nonnull Callback callback) {
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        return (UUID)this.cache.getUnchecked((Object)callback);
    }

    @Nonnull
    public Optional<Callback> get(@Nonnull UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId, (Object)"unique id");
        return Optional.ofNullable((Callback)this.inverseCache.get(uniqueId));
    }

    void remove(@Nonnull UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId, (Object)"unique id");
        Callback callback = (Callback)this.inverseCache.remove(uniqueId);
        if (callback != null) {
            this.cache.invalidate((Object)callback);
        }
    }
}

