/*
 * Decompiled with CFR 0.152.
 */
package to.hc.common.bukkit.callback;

import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import to.hc.common.bukkit.callback.Callback;
import to.hc.common.bukkit.callback.CallbackRegistry;

public final class CallbackCommand
implements CommandExecutor {
    private static final String INVALID_CALLBACK = ChatColor.RED + "The callback you provided was not valid. Keep in mind that callbacks will expire after 10 minutes, so you might want to consider clicking faster next time!";

    public boolean onCommand(CommandSender source, Command command, String alias, String[] args) {
        if (args.length > 0) {
            try {
                Optional<Callback> callback = CallbackRegistry.get().get(UUID.fromString(args[0]));
                if (callback.isPresent()) {
                    callback.get().accept(source);
                } else {
                    source.sendMessage(INVALID_CALLBACK);
                }
            }
            catch (IllegalArgumentException e) {
                source.sendMessage(INVALID_CALLBACK);
            }
            return true;
        }
        return false;
    }
}

