/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static class Slot {
        private int index;

        public Slot(int index) {
            this.index = index < 0 ? 0 : index;
        }

        public int getIndex() {
            return this.index;
        }

        public Position getPosition(Dimensions dimensions) {
            return new Position(this.getIndex() % dimensions.getWidth(), this.getIndex() / dimensions.getWidth());
        }

        public Slot transform(Dimensions from, Dimensions to, Position fromToOffset) {
            return this.getPosition(from).add(fromToOffset).getSlot(to);
        }
    }

    public static class Position {
        public static final Position ZERO = new Position(0, 0);
        public static final BinaryOperator<Position> MIN = (p1, p2) -> new Position(Integer.min(p1.getX(), p2.getX()), Integer.min(p1.getY(), p2.getY()));
        private int x;
        private int y;

        public Position(int x, int y) {
            this.x = x < 0 ? 0 : x;
            this.y = y < 0 ? 0 : y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Position add(Position position) {
            return new Position(this.getX() + position.getX(), this.getY() + position.getY());
        }

        public Position subtract(Position position) {
            return new Position(this.getX() - position.getX(), this.getY() - position.getY());
        }

        public Slot getSlot(Dimensions dimensions) {
            return new Slot(this.getY() * dimensions.getWidth() + this.getX());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Position)) {
                return false;
            }
            Position position = (Position)o;
            return this.getX() == position.getX() && this.getY() == position.getY();
        }

        public int hashCode() {
            return Objects.hash(this.getX(), this.getY());
        }

        public String toString() {
            return "(" + this.getX() + "," + this.getY() + ")";
        }
    }

    public static class Dimensions
    implements Iterable<Position> {
        public static final Dimensions SINGLE_CHEST = Dimensions.ofChest(3);
        public static final Dimensions DOUBLE_CHEST = Dimensions.ofChest(6);
        private int width;
        private int height;

        public Dimensions(int width, int height) {
            this.width = width < 1 ? 1 : width;
            this.height = height < 1 ? 1 : height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int size() {
            return this.getWidth() * this.getHeight();
        }

        public Set<Position> getPositions(Position offset) {
            HashSet<Position> positions = new HashSet<Position>();
            for (int x = 0; x < this.getWidth(); ++x) {
                for (int y = 0; y < this.getHeight(); ++y) {
                    positions.add(new Position(x, y).add(offset));
                }
            }
            return positions;
        }

        @Override
        public Iterator<Position> iterator() {
            return this.getPositions(Position.ZERO).iterator();
        }

        public boolean contains(Slot slot) {
            return slot.getIndex() < this.size();
        }

        public boolean contains(Position position) {
            return position.getX() < this.getWidth() && position.getY() < this.getHeight();
        }

        public boolean contains(Dimensions dimensions) {
            return this.getWidth() >= dimensions.getWidth() && this.getHeight() >= dimensions.getHeight();
        }

        public boolean expand(Slot slot, ExpandMode mode, Dimensions max) {
            if (slot.getIndex() == max.size()) {
                return false;
            }
            while (!this.contains(slot)) {
                this.expand(mode, max);
            }
            return true;
        }

        public boolean expand(Position position, ExpandMode mode, Dimensions max) {
            if (!max.contains(position)) {
                return false;
            }
            while (!this.contains(position)) {
                this.expand(mode, max);
            }
            return true;
        }

        private void expand(ExpandMode mode, Dimensions max) {
            boolean expandHeight;
            boolean expandWidth = this.getWidth() < max.getWidth() && (mode == ExpandMode.WIDE || mode == ExpandMode.SQUARE || this.getHeight() == max.getHeight());
            boolean bl = expandHeight = this.getHeight() < max.getHeight() && (mode == ExpandMode.TALL || mode == ExpandMode.SQUARE || this.getWidth() == max.getWidth());
            if (expandHeight) {
                ++this.height;
            }
            if (expandWidth) {
                ++this.width;
            }
        }

        public static Dimensions ofChest(int rows) {
            return new Dimensions(9, rows);
        }

        public static enum ExpandMode {
            WIDE,
            TALL,
            SQUARE;

        }
    }
}

