/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.storage.value.variables;

import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.value.Value;
import java.util.Optional;

public interface VariableContainer {
    default public boolean hasVariable(String name) {
        return this.getValue(name).isPresent();
    }

    default public boolean hasVariable(String name, Class<?> type) {
        return ((Optional)((Object)this.getValue(name, (Object)type))).isPresent();
    }

    public Optional<Object> getValue(String var1);

    default public <T> Optional<T> getValue(String name, Class<T> type) {
        return this.getValue(name).filter(value -> type.isAssignableFrom(value.getClass())).map(value -> value);
    }

    default public <T> T getValue(String name, T def) {
        return ((Optional)((Object)this.getValue(name, (T)def.getClass()))).orElse(def);
    }

    public void setValue(String var1, Object var2);

    public void addDynamicValue(Value var1);

    public void resetDynamicValues();

    public void saveToNBT(NBTTagCompound var1);
}

