/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.storage.value.variables;

import com.herocraftonline.items.api.storage.nbt.NBTBase;
import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.nbt.NBTTagDouble;
import com.herocraftonline.items.api.storage.nbt.NBTTagInt;
import com.herocraftonline.items.api.storage.value.Value;
import com.herocraftonline.items.api.storage.value.variables.VariableContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;

public class BaseVariableContainer
implements VariableContainer {
    private static final String VARIABLES_TAG = "variables";
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private final List<Value> values = new ArrayList<Value>();

    @Override
    public boolean hasVariable(String name) {
        return this.variables.containsKey(name);
    }

    @Override
    public Optional<Object> getValue(String name) {
        return Optional.ofNullable(this.variables.get(name));
    }

    @Override
    public void setValue(String name, Object value) {
        this.variables.put(name, value);
        this.resetDynamicValues();
    }

    @Override
    public void addDynamicValue(Value value) {
        this.values.add(value);
    }

    @Override
    public void resetDynamicValues() {
        this.values.forEach(Value::reset);
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        NBTTagCompound variableCompound = NBTTagCompound.create();
        for (Map.Entry<String, Object> variable : this.variables.entrySet()) {
            Object value = variable.getValue();
            if (value instanceof Integer) {
                variableCompound.setInt(variable.getKey(), (Integer)value);
                continue;
            }
            if (!(value instanceof Double)) continue;
            variableCompound.setDouble(variable.getKey(), (Double)value);
        }
        compound.setBase(VARIABLES_TAG, variableCompound);
    }

    public static VariableContainer loadFromNBT(NBTTagCompound compound) {
        BaseVariableContainer variables = new BaseVariableContainer();
        NBTTagCompound variableCompound = compound.getCompound(VARIABLES_TAG);
        for (String variable : variableCompound.getKeySet()) {
            Number var;
            NBTBase base = variableCompound.getBase(variable);
            if (base instanceof NBTTagInt) {
                var = variableCompound.getInt(variable);
                variables.setValue(variable, var);
                continue;
            }
            if (!(base instanceof NBTTagDouble)) continue;
            var = variableCompound.getDouble(variable);
            variables.setValue(variable, var);
        }
        return variables;
    }

    public static VariableContainer loadFromConfig(ConfigurationSection config) {
        BaseVariableContainer variables = new BaseVariableContainer();
        if (config.isConfigurationSection(VARIABLES_TAG)) {
            ConfigurationSection variableConfig = config.getConfigurationSection(VARIABLES_TAG);
            for (String variable : variableConfig.getKeys(false)) {
                if (variableConfig.isInt(variable)) {
                    variables.setValue(variable, variableConfig.getInt(variable));
                    continue;
                }
                if (!variableConfig.isDouble(variable)) continue;
                variables.setValue(variable, variableConfig.getDouble(variable));
            }
        }
        return variables;
    }
}

