/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.storage.value.replacer;

import com.herocraftonline.items.api.storage.value.replacer.Replaceable;
import com.herocraftonline.items.api.storage.value.replacer.Replacer;
import java.util.regex.Pattern;

public class WeightedListReplacer
extends Replacer {
    private static final String ELEMENT = "[^\\[(<:,\\s>\\])]*:([1-9]\\d*|\\d\\.\\d*[1-9])+";
    private static final Pattern WEIGHTED_CHANCE = Pattern.compile("<[^\\[(<:,\\s>\\])]*:([1-9]\\d*|\\d\\.\\d*[1-9])+(,[^\\[(<:,\\s>\\])]*:([1-9]\\d*|\\d\\.\\d*[1-9])+)*>");

    public WeightedListReplacer(Replaceable value) {
        super(WEIGHTED_CHANCE.matcher(value.getString()), value);
    }

    @Override
    public String getValue(String replace) {
        String list = replace.substring(1, replace.length() - 1);
        String[] elements = list.split(",");
        Double[] values = new Double[elements.length];
        double total = 0.0;
        for (int i = 0; i < elements.length; ++i) {
            String[] element = elements[i].split(":");
            elements[i] = element[0];
            values[i] = Double.valueOf(element[1]);
            total += values[i].doubleValue();
        }
        double random = RANDOM.nextDouble() * total;
        double weight = 0.0;
        for (int i = 0; i < elements.length; ++i) {
            if (!((weight += values[i].doubleValue()) >= random)) continue;
            return elements[i];
        }
        return "";
    }
}

