/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.storage.value.replacer;

import com.herocraftonline.items.api.storage.value.replacer.Replaceable;
import com.herocraftonline.items.api.storage.value.replacer.Replacer;
import java.util.regex.Pattern;

public class RangeReplacer
extends Replacer {
    private static final String VALUE = "-?\\d+(\\.\\d+)?";
    private static final Pattern PAIR = Pattern.compile("\\(-?\\d+(\\.\\d+)?,-?\\d+(\\.\\d+)?\\)");

    public RangeReplacer(Replaceable value) {
        super(PAIR.matcher(value.getString()), value);
    }

    @Override
    public String getValue(String replace) {
        int comma = replace.indexOf(44);
        double min = Double.parseDouble(replace.substring(1, comma));
        double max = Double.parseDouble(replace.substring(comma + 1, replace.length() - 1));
        double value = min + RANDOM.nextDouble() * (max - min);
        return replace.contains(".") ? Double.toString(value) : Integer.toString((int)value);
    }
}

