/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.storage.value.replacer;

import com.herocraftonline.items.api.storage.value.replacer.Replaceable;
import com.herocraftonline.items.api.storage.value.replacer.Replacer;
import java.util.regex.Pattern;

public class InterpolateReplacer
extends Replacer {
    private static final String VALUE = "-?\\d+(\\.\\d+)?";
    private static final Pattern TRIPLE = Pattern.compile("\\((-?\\d+(\\.\\d+)?,){2}-?\\d+(\\.\\d+)?\\)");

    public InterpolateReplacer(Replaceable value) {
        super(TRIPLE.matcher(value.getString()), value);
    }

    @Override
    public String getValue(String replace) {
        int firstComma = replace.indexOf(44);
        int lastComma = replace.lastIndexOf(44);
        double min = Double.parseDouble(replace.substring(1, firstComma));
        double max = Double.parseDouble(replace.substring(firstComma + 1, lastComma));
        double fraction = Double.parseDouble(replace.substring(lastComma + 1, replace.length() - 1));
        fraction = Math.max(0.0, Math.min(fraction, 1.0));
        double value = min + fraction * (max - min);
        return replace.substring(1, lastComma).contains(".") ? Double.toString(value) : Integer.toString((int)value);
    }
}

