/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.storage.value;

import com.herocraftonline.items.api.storage.nbt.NBTBase;
import com.herocraftonline.items.api.storage.nbt.NBTNumber;
import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.nbt.NBTTagList;
import com.herocraftonline.items.api.storage.nbt.NBTTagString;
import com.herocraftonline.items.api.storage.value.DynamicList;
import com.herocraftonline.items.api.storage.value.DynamicValue;
import com.herocraftonline.items.api.storage.value.StaticValue;
import com.herocraftonline.items.api.storage.value.Value;
import com.herocraftonline.items.api.storage.value.variables.VariableContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;

public class StoredValue<T> {
    private final String key;
    private final Type<T> type;
    private final T def;
    private final boolean cache;
    private final boolean dynamic;
    public static final ValueType<Boolean> BOOLEAN = new ValueType<Boolean>(Boolean::parseBoolean, o -> o instanceof Boolean, o -> (Boolean)o, b -> b instanceof NBTNumber, b -> ((NBTNumber)b).asByte() != 0);
    public static final ValueType<Double> DOUBLE = new ValueType<Double>(Double::parseDouble, o -> o instanceof Number, o -> ((Number)o).doubleValue(), b -> b instanceof NBTNumber, b -> ((NBTNumber)b).asDouble());
    public static final ValueType<Integer> INTEGER = new ValueType<Integer>(Integer::parseInt, o -> o instanceof Number, o -> ((Number)o).intValue(), b -> b instanceof NBTNumber, b -> ((NBTNumber)b).asInt());
    public static final ValueType<Long> LONG = new ValueType<Long>(Long::parseLong, o -> o instanceof Number, o -> ((Number)o).longValue(), b -> b instanceof NBTNumber, b -> ((NBTNumber)b).asLong());
    public static final ValueType<String> STRING = new ValueType<String>(Function.identity(), o -> true, Object::toString, b -> b instanceof NBTTagString, b -> ((NBTTagString)b).getString());
    public static final ListType<String> STRING_LIST = new ListType(Function.identity(), o -> o instanceof List, o -> ((List)o).stream().map(String::valueOf).collect(Collectors.toList()), b -> b instanceof NBTTagList, b -> {
        ArrayList<String> text = new ArrayList<String>();
        NBTTagList list = (NBTTagList)b;
        for (int i = 0; i < list.size(); ++i) {
            text.add(list.getString(i));
        }
        return text;
    });
    private static final BiFunction<ConfigurationSection, String, Boolean> CONFIG_CONTAINS = ConfigurationSection::contains;
    private static final BiFunction<ConfigurationSection, String, Object> CONFIG_GET = ConfigurationSection::get;
    private static final Function<Object, String> CONFIG_STRING = Object::toString;
    private static final Function<Object, List<String>> CONFIG_STRING_LIST = StoredValue.STRING_LIST.configValue;
    private static final BiFunction<NBTTagCompound, String, Boolean> NBT_CONTAINS = NBTTagCompound::hasKey;
    private static final BiFunction<NBTTagCompound, String, NBTBase> NBT_GET = NBTTagCompound::getBase;
    private static final Function<NBTBase, String> NBT_STRING = b -> ((NBTTagString)b).getString();
    private static final Function<NBTBase, List<String>> NBT_STRING_LIST = StoredValue.STRING_LIST.nbtValue;

    public StoredValue(String key, Type<T> type, T def, boolean cache, boolean dynamic) {
        this.key = key;
        this.type = type;
        this.def = def;
        this.cache = cache;
        this.dynamic = dynamic;
    }

    public StoredValue(String key, Type<T> type, T def, boolean cache) {
        this(key, type, def, cache, type == STRING);
    }

    public StoredValue(String key, Type<T> type, boolean cache, boolean dynamic) {
        this(key, type, null, cache, dynamic);
    }

    public StoredValue(String key, Type<T> type, boolean cache) {
        this(key, type, null, cache);
    }

    public StoredValue(String key, Type<T> type, T def) {
        this(key, type, def, true);
    }

    public StoredValue(String key, Type<T> type) {
        this(key, type, null);
    }

    public String getKey() {
        return this.key;
    }

    public T getDefault() {
        return this.def;
    }

    public Value<T> loadFromConfig(VariableContainer variables, ConfigurationSection config) {
        if (this.type instanceof ListType) {
            StoredValue value = this;
            return StoredValue.loadList(variables, config, value);
        }
        return StoredValue.loadValue(variables, config, this);
    }

    public Value<T> loadFromNBT(VariableContainer variables, NBTTagCompound compound) {
        if (this.type instanceof ListType) {
            StoredValue value = this;
            return StoredValue.loadList(variables, compound, value);
        }
        return StoredValue.loadValue(variables, compound, this);
    }

    private static <S, V, T> Value<T> loadValue(VariableContainer variables, S storage, BiFunction<S, String, Boolean> contains, BiFunction<S, String, V> get, Function<V, String> toString, Predicate<V> valCheck, Function<V, T> value, Function<String, T> parse, String key, T def, boolean cache, boolean dynamic) {
        if (contains.apply(storage, key).booleanValue()) {
            V val = get.apply(storage, key);
            try {
                if (dynamic || !valCheck.test(val)) {
                    DynamicValue<T> dynamicValue = new DynamicValue<T>(variables, key, toString.apply(val), parse, def, cache);
                    variables.addDynamicValue(dynamicValue);
                    return dynamicValue;
                }
                return new StaticValue<T>(key, value.apply(val));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new StaticValue<T>(def);
    }

    private static <S, V, T> Value<List<T>> loadList(VariableContainer variables, S storage, BiFunction<S, String, Boolean> contains, BiFunction<S, String, V> get, Function<V, List<String>> toList, Predicate<V> valCheck, Function<V, List<T>> value, Function<String, T> parse, String key, List<T> def, boolean cache, boolean dynamic) {
        if (contains.apply(storage, key).booleanValue()) {
            V val = get.apply(storage, key);
            try {
                if (dynamic || !valCheck.test(val)) {
                    DynamicList<T> dynamicList = new DynamicList<T>(variables, key, toList.apply(val), parse, def, cache);
                    variables.addDynamicValue(dynamicList);
                    return dynamicList;
                }
                return new StaticValue<List<T>>(key, value.apply(val));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new StaticValue<List<T>>(def);
    }

    private static <T> Value<T> loadValue(VariableContainer variables, ConfigurationSection config, StoredValue<T> value) {
        if (value.type instanceof ValueType) {
            ValueType type = (ValueType)value.type;
            return StoredValue.loadValue(variables, config, CONFIG_CONTAINS, CONFIG_GET, CONFIG_STRING, type.configCheck, type.configValue, type.parse, value.key, value.def, value.cache, value.dynamic);
        }
        return new StaticValue<T>(value.def);
    }

    private static <T> Value<List<T>> loadList(VariableContainer variables, ConfigurationSection config, StoredValue<List<T>> value) {
        if (value.type instanceof ListType) {
            ListType type = (ListType)value.type;
            return StoredValue.loadList(variables, config, CONFIG_CONTAINS, CONFIG_GET, CONFIG_STRING_LIST, type.configCheck, type.configValue, type.parse, value.key, (List)value.def, value.cache, value.dynamic);
        }
        return new StaticValue<List<T>>(value.def);
    }

    private static <T> Value<T> loadValue(VariableContainer variables, NBTTagCompound compound, StoredValue<T> value) {
        if (value.type instanceof ValueType) {
            ValueType type = (ValueType)value.type;
            return StoredValue.loadValue(variables, compound, NBT_CONTAINS, NBT_GET, NBT_STRING, type.nbtCheck, type.nbtValue, type.parse, value.key, value.def, value.cache, value.dynamic);
        }
        return new StaticValue<T>(value.def);
    }

    private static <T> Value<List<T>> loadList(VariableContainer variables, NBTTagCompound compound, StoredValue<List<T>> value) {
        if (value.type instanceof ListType) {
            ListType type = (ListType)value.type;
            return StoredValue.loadList(variables, compound, NBT_CONTAINS, NBT_GET, NBT_STRING_LIST, type.nbtCheck, type.nbtValue, type.parse, value.key, (List)value.def, value.cache, value.dynamic);
        }
        return new StaticValue<List<T>>(value.def);
    }

    private static class ListType<T>
    extends Type<List<T>> {
        protected final Function<String, T> parse;
        protected final Function<Object, List<T>> configValue;
        protected final Function<NBTBase, List<T>> nbtValue;

        public ListType(Function<String, T> parse, Predicate<Object> configCheck, Function<Object, List<T>> configValue, Predicate<NBTBase> nbtCheck, Function<NBTBase, List<T>> nbtValue) {
            super(configCheck, nbtCheck);
            this.parse = parse;
            this.configValue = configValue;
            this.nbtValue = nbtValue;
        }
    }

    private static class ValueType<T>
    extends Type<T> {
        protected final Function<String, T> parse;
        protected final Function<Object, T> configValue;
        protected final Function<NBTBase, T> nbtValue;

        public ValueType(Function<String, T> parse, Predicate<Object> configCheck, Function<Object, T> configValue, Predicate<NBTBase> nbtCheck, Function<NBTBase, T> nbtValue) {
            super(configCheck, nbtCheck);
            this.parse = parse;
            this.configValue = configValue;
            this.nbtValue = nbtValue;
        }
    }

    private static class Type<T> {
        protected final Predicate<Object> configCheck;
        protected final Predicate<NBTBase> nbtCheck;

        public Type(Predicate<Object> configCheck, Predicate<NBTBase> nbtCheck) {
            this.configCheck = configCheck;
            this.nbtCheck = nbtCheck;
        }
    }
}

