/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.storage.value;

import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.value.Value;

public class StaticValue<T>
implements Value<T> {
    private final String key;
    private final T value;

    public StaticValue(String key, T value) {
        this.key = key;
        this.value = value;
    }

    public StaticValue(T value) {
        this(null, value);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        if (this.key != null) {
            if (this.value instanceof Boolean) {
                compound.setBoolean(this.key, (Boolean)this.value);
            } else if (this.value instanceof Double) {
                compound.setDouble(this.key, (Double)this.value);
            } else if (this.value instanceof Integer) {
                compound.setInt(this.key, (Integer)this.value);
            } else if (this.value instanceof Long) {
                compound.setLong(this.key, (Long)this.value);
            } else if (this.value instanceof String) {
                compound.setString(this.key, (String)this.value);
            }
        }
    }
}

