/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.storage.value;

import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.value.Value;
import com.herocraftonline.items.api.storage.value.replacer.Replaceable;
import com.herocraftonline.items.api.storage.value.replacer.VariableReplaceable;
import com.herocraftonline.items.api.storage.value.variables.VariableContainer;
import java.util.function.Function;

public class DynamicValue<T>
implements Value<T> {
    private final String key;
    private final String value;
    private final T def;
    private final Replaceable replaceable;
    private final Function<String, T> parse;
    private final boolean cache;
    private T last;

    public DynamicValue(VariableContainer variables, String key, String value, Function<String, T> parse, T def, boolean cache) {
        this.key = key;
        this.value = value;
        this.def = def;
        this.replaceable = new VariableReplaceable(variables);
        this.parse = parse;
        this.cache = cache;
        this.last = null;
    }

    @Override
    public T getValue() {
        if (this.last == null || !this.cache) {
            try {
                this.last = this.parse.apply(this.replaceable.replace(this.value));
            }
            catch (Exception e) {
                this.last = this.def;
            }
        }
        return this.last;
    }

    @Override
    public void reset() {
        this.last = null;
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        if (this.key != null) {
            compound.setString(this.key, this.value);
        }
    }
}

