/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.storage.value;

import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.nbt.NBTTagList;
import com.herocraftonline.items.api.storage.nbt.NBTTagString;
import com.herocraftonline.items.api.storage.value.Value;
import com.herocraftonline.items.api.storage.value.replacer.Replaceable;
import com.herocraftonline.items.api.storage.value.replacer.VariableReplaceable;
import com.herocraftonline.items.api.storage.value.variables.VariableContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class DynamicList<T>
implements Value<List<T>> {
    private final String key;
    private final List<String> value;
    private final List<T> def;
    private final Replaceable replaceable;
    private final Function<String, T> parse;
    private final boolean cache;
    private List<T> last;

    public DynamicList(VariableContainer variables, String key, List<String> value, Function<String, T> parse, List<T> def, boolean cache) {
        this.key = key;
        this.value = value;
        this.def = def;
        this.replaceable = new VariableReplaceable(variables);
        this.parse = parse;
        this.cache = cache;
        this.last = null;
    }

    @Override
    public List<T> getValue() {
        if (this.last == null || !this.cache) {
            try {
                ArrayList<T> list = new ArrayList<T>();
                for (String string : this.value) {
                    list.add(this.parse.apply(this.replaceable.replace(string)));
                }
                this.last = list;
            }
            catch (Exception e) {
                this.last = this.def;
            }
        }
        return this.last;
    }

    @Override
    public void reset() {
        this.last = null;
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        if (this.key != null) {
            NBTTagList list = NBTTagList.create();
            for (String string : this.value) {
                list.addBase(NBTTagString.create(string));
            }
            compound.setBase(this.key, list);
        }
    }
}

