/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.storage.config.transform;

import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.storage.config.ConfigManager;
import com.herocraftonline.items.api.storage.config.transform.ConfigTransform;
import java.util.regex.Pattern;
import org.bukkit.configuration.ConfigurationSection;

public class ReferenceTransform
extends ConfigTransform {
    private static final Pattern CONFIG = Pattern.compile("#\\{[\\w/-]*[\\w-]+(\\[([\\S\\t ])*])?}");

    public ReferenceTransform(ItemPlugin plugin) {
        super(plugin);
    }

    @Override
    public ConfigurationSection transform(ConfigurationSection section, Object[] args) {
        ConfigManager configManager = this.plugin.getConfigManager();
        section.getKeys(true).stream().filter(arg_0 -> ((ConfigurationSection)section).isString(arg_0)).forEach(key -> {
            String string = section.getString(key);
            if (CONFIG.matcher(string).matches()) {
                Object[] argz;
                String path;
                if (string.contains("[")) {
                    int bracket = string.indexOf("[");
                    path = string.substring(2, bracket);
                    String[] split = string.substring(bracket + 1, string.length() - 2).split(",");
                    argz = new Object[split.length];
                    System.arraycopy(split, 0, argz, 0, split.length);
                } else {
                    path = string.substring(2, string.length() - 1);
                    argz = args;
                }
                ConfigurationSection value = configManager.loadAndTransform("configs/" + path + ".yml", this.plugin, argz);
                ReferenceTransform.setValue(section, key, (Object)value);
            }
        });
        return section;
    }
}

