/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.storage.config.transform;

import com.herocraftonline.items.api.ItemPlugin;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.bukkit.configuration.ConfigurationSection;

public abstract class ConfigTransform {
    protected static final Pattern NUMBER = Pattern.compile("-?\\d+(\\.\\d+)?");
    protected static final Random RANDOM = new Random();
    protected final ItemPlugin plugin;

    public ConfigTransform(ItemPlugin plugin) {
        this.plugin = plugin;
    }

    protected static void setValue(ConfigurationSection section, String key, Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if (NUMBER.matcher(string).matches()) {
                double number = Double.valueOf(string);
                if (string.contains(".")) {
                    section.set(key, (Object)number);
                } else {
                    section.set(key, (Object)((int)number));
                }
                return;
            }
            if (string.isEmpty()) {
                section.set(key, null);
                return;
            }
        }
        section.set(key, value);
    }

    protected static void setValue(List<Object> list, int index, Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if (NUMBER.matcher(string).matches()) {
                double number = Double.valueOf(string);
                if (string.contains(".")) {
                    list.set(index, number);
                } else {
                    list.set(index, (int)number);
                }
                return;
            }
            if (string.isEmpty()) {
                list.remove(index);
                return;
            }
        }
        list.set(index, value);
    }

    public abstract ConfigurationSection transform(ConfigurationSection var1, Object[] var2);
}

