/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.message;

import com.herocraftonline.items.api.message.Messenger;
import java.util.ArrayList;
import java.util.List;

public class PageList {
    private final String name;
    private final int pageSize;
    private List<List<String>> pages;

    public PageList(String name, int pageSize, String ... lines) {
        this.name = name;
        this.pageSize = pageSize;
        this.pages = new ArrayList<List<String>>();
        this.pages.add(new ArrayList());
        this.pages.get(0).add(this.getHeader(1));
        this.add(lines);
    }

    public int getTotalPages() {
        return this.pages.size();
    }

    public List<String> getPage(int pageNumber) {
        pageNumber = Math.max(1, Math.min(pageNumber, this.pages.size()));
        return this.pages.get(pageNumber - 1);
    }

    public List<String> getLastPage() {
        return this.pages.get(this.pages.size() - 1);
    }

    public String getLine(int pageNumber, int lineNumber) {
        List<String> page = this.getPage(pageNumber);
        lineNumber = Math.max(1, Math.min(lineNumber, page.size() - 1));
        return page.get(lineNumber);
    }

    public void add(String ... lines) {
        for (String line : lines) {
            if (this.getLastPage().size() > this.pageSize) {
                this.pages.add(new ArrayList());
                this.getLastPage().add(this.getHeader(this.pages.size()));
                for (int i = 1; i < this.pages.size(); ++i) {
                    this.pages.get(i - 1).set(0, this.getHeader(i));
                }
            }
            this.getLastPage().add(line);
        }
    }

    private String getHeader(int pageNumber) {
        return Messenger.HIGHLIGHT_COLOR + "<-------<| " + Messenger.PRIMARY_COLOR + this.name + ": Page " + pageNumber + "/" + this.pages.size() + " " + Messenger.HIGHLIGHT_COLOR + "|>------->";
    }

    public static int getPageNumber(String pageNumber) {
        int page;
        try {
            page = Integer.parseInt(pageNumber);
        }
        catch (NumberFormatException e) {
            page = 1;
        }
        return page;
    }
}

