/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.message;

import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.message.Message;
import com.herocraftonline.items.api.message.RelMessage;
import com.herocraftonline.items.api.storage.config.ConfigAccessor;
import com.herocraftonline.items.api.storage.config.DefaultConfig;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class Messenger {
    private ItemPlugin plugin;
    private boolean debug;
    private Logger log;
    private Map<Class<?>, RecipientHandler> recipientHandlers = new HashMap();
    public static ChatColor PRIMARY_COLOR = ChatColor.AQUA;
    public static ChatColor SECONDARY_COLOR = ChatColor.GRAY;
    public static ChatColor HIGHLIGHT_COLOR = ChatColor.DARK_GRAY;

    public Messenger(ItemPlugin plugin) {
        this.plugin = plugin;
        this.debug = plugin.getConfig().getBoolean("debug", false);
        this.log = plugin.getLogger();
        this.registerMessages(EnumSet.allOf(RelMessage.class));
        this.registerRecipient(CommandSender.class, (recipient, message) -> ((CommandSender)recipient).sendMessage(message));
        this.registerRecipient(Server.class, (recipient, message) -> ((Server)recipient).broadcastMessage(message));
        FileConfiguration config = plugin.getConfig();
        PRIMARY_COLOR = ChatColor.valueOf((String)config.getString("colors.primary", "AQUA"));
        SECONDARY_COLOR = ChatColor.valueOf((String)config.getString("colors.secondary", "GRAY"));
        HIGHLIGHT_COLOR = ChatColor.valueOf((String)config.getString("colors.highlights", "DARK_GRAY"));
    }

    public Messenger registerMessages(EnumSet<? extends Message> messages) {
        ConfigAccessor messageConfig = this.plugin.getConfigManager().getConfigAccessor(DefaultConfig.MESSAGE);
        FileConfiguration messageConfigFile = messageConfig.getConfig();
        messages.stream().filter(message -> !messageConfigFile.isString(((Message)((Object)message)).getPath())).forEach(message -> messageConfigFile.set(((Message)((Object)message)).getPath(), (Object)((Message)((Object)message)).getMessage()));
        messageConfig.saveConfig();
        for (Message message2 : messages) {
            message2.setMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)messageConfigFile.getString(message2.getPath())));
        }
        return this;
    }

    public Messenger registerRecipient(Class recipientClass, RecipientHandler recipientHandler) {
        this.recipientHandlers.put(recipientClass, recipientHandler);
        return this;
    }

    public void sendMessage(Object recipient, Message message, Object ... replace) {
        for (String s : (replace == null ? message.getMessage() : String.format(message.getMessage(), replace)).split("\\\\n")) {
            this.sendRawMessage(recipient, RelMessage.PREFIX + s);
        }
    }

    public void sendErrorMessage(Object recipient, Message message, Object ... replace) {
        for (String s : (replace == null ? message.getMessage() : String.format(message.getMessage(), replace)).split("\\\\n")) {
            this.sendRawMessage(recipient, RelMessage.PREFIX_ERROR + s);
        }
    }

    public void sendShortMessage(Object recipient, Message message, Object ... replace) {
        for (String s : (replace == null ? message.getMessage() : String.format(message.getMessage(), replace)).split("\\\\n")) {
            this.sendRawMessage(recipient, RelMessage.PREFIX_SHORT + s);
        }
    }

    public void sendShortErrorMessage(Object recipient, Message message, Object ... replace) {
        for (String s : (replace == null ? message.getMessage() : String.format(message.getMessage(), replace)).split("\\\\n")) {
            this.sendRawMessage(recipient, RelMessage.PREFIX_ERROR_SHORT + s);
        }
    }

    public void sendRawMessage(Object recipient, Object message) {
        if (recipient != null && message != null) {
            for (Class<?> recipientClass : this.recipientHandlers.keySet()) {
                if (!recipientClass.isAssignableFrom(recipient.getClass())) continue;
                this.recipientHandlers.get(recipientClass).sendMessage(recipient, message.toString());
                break;
            }
        }
    }

    public void log(Level level, Object ... messages) {
        for (Object message : messages) {
            this.log.log(level, message.toString());
        }
    }

    public void debug(Exception e) {
        if (this.debug) {
            e.printStackTrace();
        }
    }

    public void debug(Object message) {
        if (this.debug) {
            this.log.log(Level.INFO, message.toString());
        }
    }

    public Logger getLogger() {
        return this.log;
    }

    public static interface RecipientHandler {
        public void sendMessage(Object var1, String var2);
    }
}

