/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.item.attribute.attributes.trigger.triggerables;

import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.attribute.attributes.trigger.Triggerable;
import com.herocraftonline.items.api.item.attribute.attributes.trigger.result.TriggerResult;
import com.herocraftonline.items.api.item.attribute.attributes.trigger.source.TriggerSource;
import com.herocraftonline.items.api.item.attribute.attributes.trigger.source.item.ItemSource;
import java.util.Optional;

public interface IncreaseVariable
extends Triggerable<IncreaseVariable> {
    public String getVariable();

    public double getAmount();

    @Override
    default public boolean canTrigger(TriggerSource source) {
        if (this.getVariable() == null || this.getVariable().isEmpty() || this.getAmount() == 0.0) {
            return false;
        }
        Item item = source.ofType(ItemSource.class).map(ItemSource::getSourceItem).orElse(source.getItem());
        return item.hasVariable(this.getVariable(), Integer.class) || item.hasVariable(this.getVariable(), Double.class);
    }

    @Override
    default public TriggerResult onTrigger(TriggerSource source) {
        if (this.getVariable() == null || this.getVariable().isEmpty() || this.getAmount() == 0.0) {
            return TriggerResult.NOT_TRIGGERED;
        }
        Item item = source.ofType(ItemSource.class).map(ItemSource::getSourceItem).orElse(source.getItem());
        Class<Integer> intValue = item.getValue(this.getVariable(), Integer.class);
        if (((Optional)((Object)intValue)).isPresent()) {
            Integer upgraded = (Integer)((Optional)((Object)intValue)).get() + (int)this.getAmount();
            item.setValue(this.getVariable(), upgraded);
            return TriggerResult.UPDATE_ITEM;
        }
        Class<Double> doubleValue = item.getValue(this.getVariable(), Double.class);
        if (((Optional)((Object)doubleValue)).isPresent()) {
            Double upgraded = (Double)((Optional)((Object)doubleValue)).get() + this.getAmount();
            item.setValue(this.getVariable(), upgraded);
            return TriggerResult.UPDATE_ITEM;
        }
        return TriggerResult.NOT_TRIGGERED;
    }
}

