/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.item.attribute.attributes.trigger;

import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.attribute.AttributeType;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttribute;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttributeFactory;
import com.herocraftonline.items.api.item.attribute.attributes.trigger.Trigger;
import com.herocraftonline.items.api.item.attribute.attributes.trigger.Triggerable;
import com.herocraftonline.items.api.item.attribute.attributes.trigger.result.TriggerResult;
import com.herocraftonline.items.api.item.attribute.attributes.trigger.source.TriggerSource;
import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.nbt.NBTTagList;
import com.herocraftonline.items.api.storage.nbt.NBTTagString;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.bukkit.configuration.ConfigurationSection;

public abstract class BaseTrigger<T extends Trigger<T>>
extends BaseAttribute<T>
implements Trigger<T> {
    private final List<String> targets;
    private final boolean separate;

    public BaseTrigger(Item item, String name, AttributeType<T> type, List<String> targets, boolean separate) {
        super(item, name, type);
        this.targets = targets;
        this.separate = separate;
    }

    @Override
    public boolean canTrigger(TriggerSource source) {
        Stream<Triggerable> targets = this.getTargets().stream().map(target -> source.getItem().getAttributeDeep(Triggerable.class, (String)target)).filter(Optional::isPresent).map(Optional::get);
        return this.handleSeparately() ? targets.anyMatch(triggerable -> triggerable.canTrigger(source)) : targets.allMatch(triggerable -> triggerable.canTrigger(source));
    }

    @Override
    public TriggerResult onTrigger(TriggerSource source) {
        Stream<Triggerable> targets = this.getTargets().stream().map(target -> source.getItem().getAttributeDeep(Triggerable.class, (String)target)).filter(Optional::isPresent).map(Optional::get);
        return targets.map(triggerable -> triggerable.onTrigger(source)).reduce(this.handleSeparately() ? TriggerResult.SEPARATE : TriggerResult.COMBINED).orElse(TriggerResult.NOT_TRIGGERED);
    }

    @Override
    public List<String> getTargets() {
        return this.targets;
    }

    @Override
    public boolean handleSeparately() {
        return this.separate;
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        super.saveToNBT(compound);
        NBTTagList targets = NBTTagList.create();
        this.getTargets().forEach(target -> targets.addBase(NBTTagString.create(target)));
        compound.setBase("targets", targets);
        compound.setBoolean("separate", this.handleSeparately());
    }

    public static abstract class BaseTriggerFactory<T extends Trigger<T>>
    extends BaseAttributeFactory<T> {
        public BaseTriggerFactory(ItemPlugin plugin) {
            super(plugin);
        }

        protected List<String> loadTargetsFromConfig(ConfigurationSection config) {
            if (config.isString("target")) {
                ArrayList<String> target = new ArrayList<String>();
                target.add(config.getString("target"));
                return target;
            }
            return config.getStringList("targets");
        }

        protected List<String> loadTargetsFromNBT(NBTTagCompound compound) {
            ArrayList<String> targets = new ArrayList<String>();
            NBTTagList targetList = compound.getList("targets", NBTTagString.create().getTypeId());
            for (int i = 0; i < targetList.size(); ++i) {
                targets.add(targetList.getString(i));
            }
            return targets;
        }
    }
}

