/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.item.attribute.attributes.requirements;

import com.herocraftonline.items.api.item.attribute.attributes.requirements.EquipRequirement;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatAttribute;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatSpecifier;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatTotal;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatType;
import java.util.List;
import java.util.Map;

public interface LevelRequirement
extends EquipRequirement<LevelRequirement>,
StatAttribute<LevelRequirement> {
    public int getLevel();

    public void setLevel(int var1);

    public static class LevelRequirementStatType
    implements StatType<LevelRequirement> {
        private final String text;

        public LevelRequirementStatType(String text) {
            this.text = text;
        }

        @Override
        public StatType.Position getPosition() {
            return StatType.Position.FARTHEST_BOTTOM;
        }

        @Override
        public StatTotal<LevelRequirement> newTotal(StatSpecifier<LevelRequirement> specifier) {
            return new StatTotal<LevelRequirement>(specifier){
                private int level;

                @Override
                public void addStat(LevelRequirement stat) {
                    this.level += stat.getLevel();
                }

                @Override
                public void addTo(List<String> lore, String prefix) {
                    lore.add(prefix + text + " " + this.level);
                }
            };
        }

        @Override
        public void addTo(List<String> lore, Map<StatSpecifier<LevelRequirement>, StatTotal<LevelRequirement>> stats) {
            stats.forEach((specifier, total) -> total.addTo(lore, ""));
        }
    }
}

