/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.item.attribute.attributes.gems;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;

public enum SocketColor {
    AQUA,
    BLACK,
    BLUE,
    DARK_AQUA,
    DARK_BLUE,
    DARK_GRAY,
    DARK_GREEN,
    DARK_PURPLE,
    DARK_RED,
    GOLD,
    GRAY,
    GREEN,
    LIGHT_PURPLE,
    RED,
    WHITE,
    YELLOW;

    private static final Map<String, SocketColor> colorByName;
    private final String name = this.name().toLowerCase().replace('_', '-');
    private final ChatColor color = ChatColor.valueOf((String)this.name());
    private final Set<SocketColor> accepts = new HashSet<SocketColor>();

    private SocketColor() {
        this.accepts.add(this);
    }

    public static SocketColor fromName(String name) {
        SocketColor color = colorByName.get(name);
        return color == null ? SocketColor.valueOf(name) : color;
    }

    public static SocketColor fromChatColor(ChatColor color) {
        return SocketColor.valueOf(color.name());
    }

    public String getName() {
        return this.name;
    }

    public ChatColor getChatColor() {
        return this.color;
    }

    public Set<SocketColor> getAcceptedColors() {
        return this.accepts;
    }

    public void setAcceptedColors(Collection<SocketColor> accepts) {
        this.accepts.clear();
        this.accepts.addAll(accepts);
    }

    static {
        colorByName = new HashMap<String, SocketColor>();
        for (SocketColor color : SocketColor.values()) {
            colorByName.put(color.getName(), color);
        }
    }
}

