/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.item.attribute.attributes.base;

import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.item.attribute.Attribute;
import com.herocraftonline.items.api.item.attribute.AttributeFactory;
import com.herocraftonline.items.api.item.attribute.AttributeType;
import java.util.function.Function;

public class BaseAttributeType<T extends Attribute<T>>
implements AttributeType<T> {
    private final String name;
    private final String fileName;
    private int lorePosition;
    private final Function<ItemPlugin, AttributeFactory<T>> factoryLoader;
    private AttributeFactory<T> factory;

    public BaseAttributeType(String name, int lorePosition, Function<ItemPlugin, AttributeFactory<T>> factoryLoader) {
        this.name = name;
        this.fileName = "attributes/" + name + ".yml";
        this.lorePosition = lorePosition;
        this.factoryLoader = factoryLoader;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int getLorePosition() {
        return this.lorePosition;
    }

    @Override
    public void setLorePosition(int position) {
        this.lorePosition = position;
    }

    @Override
    public boolean test(Attribute attribute) {
        return this.equals(attribute.getType());
    }

    @Override
    public AttributeFactory<T> getFactory() {
        return this.factory;
    }

    public void loadFactory(ItemPlugin plugin) {
        this.factory = this.factoryLoader.apply(plugin);
    }
}

