/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.item.attribute.attributes.base;

import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.attribute.Attribute;
import com.herocraftonline.items.api.item.attribute.AttributeContainer;
import com.herocraftonline.items.api.item.attribute.AttributeType;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class BaseAttributeContainer<T extends Attribute<T>>
extends BaseAttribute<T>
implements AttributeContainer {
    public BaseAttributeContainer(Item item, String name, AttributeType<T> type) {
        super(item, name, type);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.hasAttribute((Attribute attribute) -> attribute.getName().equals(name));
    }

    @Override
    public boolean hasAttribute(Class<? extends Attribute> type) {
        return this.hasAttribute(Attribute.predicate(type));
    }

    @Override
    public boolean hasAttribute(Predicate<Attribute> predicate) {
        return this.getAttributes().stream().anyMatch(predicate);
    }

    @Override
    public Optional<Attribute> getAttribute(String name) {
        return this.getAttribute((Attribute attribute) -> attribute.getName().equals(name));
    }

    @Override
    public Optional<Attribute> getAttribute(Predicate<Attribute> predicate) {
        return this.getAttribute((Class<A>)Attribute.class, (Predicate)predicate);
    }

    public <A extends Attribute> Optional<A> getAttribute(Class<A> type) {
        return this.getAttribute(type, (Predicate<A>)((Predicate<Attribute>)attribute -> true));
    }

    public <A extends Attribute> Optional<A> getAttribute(Class<A> type, String name) {
        return this.getAttribute(type, (Predicate<A>)((Predicate<Attribute>)attribute -> attribute.getName().equals(name)));
    }

    public <A extends Attribute> Optional<A> getAttribute(Class<A> type, Predicate<A> predicate) {
        return this.getAttributes().stream().filter(Attribute.predicate(type)).map(attribute -> attribute).filter(predicate).findFirst();
    }

    @Override
    public Collection<Attribute> getAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        this.forEach(attributes::add);
        return attributes;
    }

    @Override
    public Collection<Attribute> getAttributes(Predicate<Attribute> predicate) {
        return this.getAttributes((Class)Attribute.class, (Predicate)predicate);
    }

    public <A extends Attribute> Collection<A> getAttributes(Class<A> type) {
        return this.getAttributes().stream().filter(Attribute.predicate(type)).map(attribute -> attribute).collect(Collectors.toList());
    }

    public <A extends Attribute> Collection<A> getAttributes(Class<A> type, Predicate<A> predicate) {
        ArrayList attributes = new ArrayList();
        this.forEach(Attribute.predicate(type), (Attribute attribute) -> {
            if (predicate.test(attribute)) {
                attributes.add(attribute);
            }
        });
        return attributes;
    }

    @Override
    public void forEach(Consumer<Attribute> action) {
        this.getAttributes().forEach(action);
    }

    @Override
    public void forEach(Predicate<Attribute> predicate, Consumer<Attribute> action) {
        this.forEach(attribute -> {
            if (predicate.test((Attribute)attribute)) {
                action.accept((Attribute)attribute);
            }
        });
    }

    public <A extends Attribute> void forEach(Class<A> type, Consumer<A> action) {
        Predicate<Attribute> predicate = Attribute.predicate(type);
        this.forEach(attribute -> {
            if (predicate.test((Attribute)attribute)) {
                action.accept(attribute);
            }
        });
    }

    public <A extends Attribute> void forEach(Class<A> type, Predicate<A> predicate, Consumer<A> action) {
        this.forEach(type, (Consumer<A>)((Consumer<Attribute>)attribute -> {
            if (predicate.test(attribute)) {
                action.accept(attribute);
            }
        }));
    }

    @Override
    public boolean hasAttributeDeep(String name) {
        return this.hasAttributeDeep((Attribute attribute) -> attribute.getName().equals(name));
    }

    @Override
    public boolean hasAttributeDeep(Class<? extends Attribute> type) {
        return this.hasAttributeDeep(Attribute.predicate(type));
    }

    @Override
    public boolean hasAttributeDeep(Predicate<Attribute> predicate) {
        return this.getAttributesDeep().stream().anyMatch(predicate);
    }

    @Override
    public Optional<Attribute> getAttributeDeep(String name) {
        return this.getAttributeDeep((Attribute attribute) -> attribute.getName().equals(name));
    }

    @Override
    public Optional<Attribute> getAttributeDeep(Predicate<Attribute> predicate) {
        return this.getAttributeDeep((Class<A>)Attribute.class, (Predicate)predicate);
    }

    public <A extends Attribute> Optional<A> getAttributeDeep(Class<A> type) {
        return this.getAttributeDeep(type, (Predicate<A>)((Predicate<Attribute>)attribute -> true));
    }

    public <A extends Attribute> Optional<A> getAttributeDeep(Class<A> type, String name) {
        return this.getAttributeDeep(type, (Predicate<A>)((Predicate<Attribute>)attribute -> attribute.getName().equals(name)));
    }

    public <A extends Attribute> Optional<A> getAttributeDeep(Class<A> type, Predicate<A> predicate) {
        return this.getAttributesDeep(type).stream().filter(predicate).findFirst();
    }

    @Override
    public Collection<Attribute> getAttributesDeep() {
        return this.getAttributesDeep((Class)Attribute.class);
    }

    @Override
    public Collection<Attribute> getAttributesDeep(Predicate<Attribute> predicate) {
        return this.getAttributesDeep((Class)Attribute.class, (Predicate)predicate);
    }

    public <A extends Attribute> Collection<A> getAttributesDeep(Class<A> type) {
        ArrayList attributes = new ArrayList();
        this.forEachDeep(Attribute.predicate(type), (Attribute attribute) -> attributes.add(attribute));
        return attributes;
    }

    public <A extends Attribute> Collection<A> getAttributesDeep(Class<A> type, Predicate<A> predicate) {
        ArrayList attributes = new ArrayList();
        this.forEachDeep(Attribute.predicate(type), (Attribute attribute) -> {
            if (predicate.test(attribute)) {
                attributes.add(attribute);
            }
        });
        return attributes;
    }

    @Override
    public void forEachDeep(Consumer<Attribute> action) {
        this.getAttributesDeep().forEach(action);
    }

    @Override
    public void forEachDeep(Predicate<Attribute> predicate, Consumer<Attribute> action) {
        this.forEachDeep(attribute -> {
            if (predicate.test((Attribute)attribute)) {
                action.accept((Attribute)attribute);
            }
        });
    }

    public <A extends Attribute> void forEachDeep(Class<A> type, Consumer<A> action) {
        Predicate<Attribute> predicate = Attribute.predicate(type);
        this.forEachDeep(attribute -> {
            if (predicate.test((Attribute)attribute)) {
                action.accept(attribute);
            }
        });
    }

    public <A extends Attribute> void forEachDeep(Class<A> type, Predicate<A> predicate, Consumer<A> action) {
        this.forEachDeep(type, (Consumer<A>)((Consumer<Attribute>)attribute -> {
            if (predicate.test(attribute)) {
                action.accept(attribute);
            }
        }));
    }
}

