/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.item.attribute.attributes.base;

import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.attribute.Attribute;
import com.herocraftonline.items.api.item.attribute.AttributeLore;
import com.herocraftonline.items.api.item.attribute.AttributeType;
import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import org.bukkit.ChatColor;

public class BaseAttribute<T extends Attribute<T>>
implements Attribute<T> {
    private final Item item;
    private final String name;
    private final AttributeType<T> type;
    private AttributeLore lore;

    public BaseAttribute(Item item, String name, AttributeType<T> type) {
        this.item = item;
        this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        this.type = type;
        this.lore = AttributeLore.NONE;
    }

    protected Item getItem() {
        return this.item;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AttributeType<T> getType() {
        return this.type;
    }

    @Override
    public AttributeLore getLore() {
        return this.lore;
    }

    protected void setLore(AttributeLore lore) {
        this.lore = lore;
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        compound.setString("type", this.type.getName());
    }
}

