/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.item.attribute.attributes;

import com.herocraftonline.items.api.item.attribute.attributes.stats.StatAttribute;
import java.util.UUID;
import org.bukkit.ChatColor;

public interface Minecraft
extends StatAttribute<Minecraft> {
    public Type getMinecraftType();

    public Slot getSlot();

    public void setSlot(Slot var1);

    public Operation getOperation();

    public void setOperation(Operation var1);

    public boolean isStacking();

    public void setStacking(boolean var1);

    public UUID getUUID();

    public double getAmount();

    public void setAmount(double var1);

    public static enum Operation {
        ADD_NUMBER(""){}
        ,
        ADD_SCALAR("%"){

            @Override
            public String amount(double amount) {
                return super.amount(amount * 100.0);
            }
        }
        ,
        MULTIPLY_SCALAR("%"){

            @Override
            public String prefix(double amount, boolean stacks) {
                return stacks ? ChatColor.BLUE + "x" : ChatColor.GRAY.toString();
            }

            @Override
            public String amount(double amount) {
                return super.amount(amount * 100.0);
            }
        };

        private final String suffix;

        private Operation(String suffix) {
            this.suffix = suffix;
        }

        public String prefix(double amount, boolean stacking) {
            return stacking ? ChatColor.BLUE + (amount > 0.0 ? "+" : "") : ChatColor.GRAY.toString();
        }

        public String amount(double amount) {
            return amount == Math.floor(amount) ? Integer.toString((int)amount) : Double.toString(amount);
        }

        public String suffix() {
            return this.suffix;
        }
    }

    public static enum Slot {
        ANY("any", "When equipped:"),
        MAIN_HAND("mainhand", "When equipped in main hand:"),
        OFF_HAND("offhand", "When equipped in off hand:"),
        HEAD("head", "When equipped on head:"),
        CHEST("chest", "When equipped on chest:"),
        LEGS("legs", "When equipped on legs:"),
        FEET("feet", "When equipped on feet:");

        private final String name;
        private String displayName;

        private Slot(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }

    public static enum Type {
        ARMOR("armor", UUID.fromString("E4A6AA09-6F0E-483F-B599-70A99CAB3A60"), "Armor"),
        ARMOR_TOUGHNESS("armorToughness", UUID.fromString("299080F9-436A-4230-BEBA-193D896293EA"), "Armor Toughness"),
        ATTACK_DAMAGE("attackDamage", UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF"), "Attack Damage"),
        ATTACK_SPEED("attackSpeed", UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3"), "Attack Speed"),
        LUCK("luck", UUID.fromString("940A0E67-89D3-4A4F-907F-ACE9524BE34E"), "Luck"),
        MAX_HEALTH("maxHealth", UUID.fromString("493E3AEC-0B14-48DF-985B-E6CAD96838BD"), "Max Health"),
        MOVEMENT_SPEED("movementSpeed", UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D"), "Movement Speed");

        private final String name;
        private final UUID uuid;
        private String displayName;

        private Type(String name, UUID uuid, String displayName) {
            this.name = "generic." + name;
            this.uuid = uuid;
            this.displayName = displayName;
        }

        public String getName() {
            return this.name;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }
}

