/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.equipment;

import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.ItemType;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public interface Equipment {
    public Player getPlayer();

    public UUID getPlayerId();

    public boolean hasSlot(String var1);

    public boolean hasSlot(ItemType var1);

    public Slot getSlot(String var1);

    public Collection<Slot> getSlots(ItemType var1);

    public Collection<Slot> getSlots();

    public boolean isSlotOpen(String var1);

    public boolean isSlotOpen(ItemType var1);

    public boolean isEquipped(Item var1);

    public boolean equip(Item var1, ItemStack var2);

    public boolean equip(Item var1, ItemStack var2, Slot var3);

    public boolean replaceEquip(Item var1, ItemStack var2);

    public boolean unEquip(Item var1, ItemStack var2);

    public void unEquipAll();

    public void load();

    public void save();

    public static class Slot {
        private final String name;
        private final ItemType type;
        private UUID itemId;

        public Slot(String name, ItemType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public ItemType getType() {
            return this.type;
        }

        public boolean isOpen() {
            return this.itemId == null;
        }

        public boolean hasItem() {
            return !this.isOpen();
        }

        public UUID getItemId() {
            return this.itemId;
        }

        public void setItemId(UUID itemId) {
            this.itemId = itemId;
        }
    }
}

