/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.command;

import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.command.Command;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.ItemManager;
import com.herocraftonline.items.api.message.Messenger;
import com.herocraftonline.items.api.message.RelMessage;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class ItemCommand
extends Command {
    public ItemCommand(ItemPlugin plugin, String name) {
        super(plugin, name);
        this.setPlayerOnly(true);
    }

    @Override
    public void execute(String command, CommandSender sender, List<String> args) {
        Player player = (Player)sender;
        Messenger messenger = this.plugin.getMessenger();
        ItemManager itemManager = this.plugin.getItemManager();
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (heldItem == null) {
            messenger.sendErrorMessage(player, RelMessage.ITEM_NOTHOLDING, new Object[0]);
        } else {
            Optional<Item> item = itemManager.getItem(heldItem);
            if (item.isPresent()) {
                this.execute(command, player, args, item.get());
            } else {
                messenger.sendErrorMessage(player, RelMessage.ITEM_NOTCUSTOM, new Object[0]);
            }
        }
    }

    public abstract void execute(String var1, Player var2, List<String> var3, Item var4);
}

