/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.command;

import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.command.Command;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.ItemManager;
import com.herocraftonline.items.api.message.Messenger;
import com.herocraftonline.items.api.message.RelMessage;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class DualItemCommand
extends Command {
    public DualItemCommand(ItemPlugin plugin, String name) {
        super(plugin, name);
        this.setPlayerOnly(true);
    }

    @Override
    public void execute(String command, CommandSender sender, List<String> args) {
        Player player = (Player)sender;
        Messenger messenger = this.plugin.getMessenger();
        ItemManager itemManager = this.plugin.getItemManager();
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        if (mainHand == null || offHand == null) {
            messenger.sendErrorMessage(player, RelMessage.ITEM_NOTHOLDING, new Object[0]);
        } else {
            Optional<Item> main = itemManager.getItem(mainHand);
            Optional<Item> off = itemManager.getItem(offHand);
            if (main.isPresent() && off.isPresent()) {
                this.execute(command, player, args, main.get(), off.get());
            } else {
                messenger.sendErrorMessage(player, RelMessage.ITEM_NOTCUSTOM, new Object[0]);
            }
        }
    }

    public abstract void execute(String var1, Player var2, List<String> var3, Item var4, Item var5);
}

