/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.command;

import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.command.Command;
import com.herocraftonline.items.api.message.Messenger;
import com.herocraftonline.items.api.message.RelMessage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;

public class CommandGroup {
    protected final ItemPlugin plugin;
    private final String name;
    private final Map<String, CommandGroup> children = new LinkedHashMap<String, CommandGroup>();
    private final List<String> tabCompleteList = new ArrayList<String>();
    private Permission permission = null;
    private int minArgsLength = 0;
    private int maxArgsLength = -1;
    private boolean playerOnly = true;
    public static final List<String> EMPTY_LIST = new ArrayList<String>();

    public CommandGroup(ItemPlugin plugin, String name) {
        this.plugin = plugin;
        this.name = name.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public ItemPlugin getPlugin() {
        return this.plugin;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
        if (Bukkit.getServer().getPluginManager().getPermission(permission.getName()) == null) {
            Bukkit.getServer().getPluginManager().addPermission(permission);
        }
    }

    public int getMinArgsLength() {
        return this.minArgsLength;
    }

    public int getMaxArgsLength() {
        return this.maxArgsLength;
    }

    public void setArgumentRange(int minArgsLength, int maxArgsLength) {
        this.minArgsLength = minArgsLength;
        this.maxArgsLength = maxArgsLength;
    }

    public boolean isPlayerOnly() {
        return this.playerOnly;
    }

    public void setPlayerOnly(boolean playerOnly) {
        this.playerOnly = playerOnly;
    }

    public boolean hasChildCommand(String name) {
        return this.children.containsKey(name.toLowerCase());
    }

    public CommandGroup getChildCommand(String name) {
        return this.children.get(name.toLowerCase());
    }

    public CommandGroup addChildCommand(CommandGroup command) {
        this.children.put(command.getName().toLowerCase(), command);
        if (command instanceof Command && ((Command)command).isVisible()) {
            this.tabCompleteList.add(command.getName().toLowerCase());
        }
        if (this.permission != null && command.getPermission() != null) {
            command.getPermission().addParent(this.permission, true);
        }
        return this;
    }

    public List<CommandGroup> getChildren(boolean deep) {
        if (deep) {
            ArrayList<CommandGroup> deepChildren = new ArrayList<CommandGroup>();
            for (CommandGroup child : this.children.values()) {
                if (child instanceof Command && !deepChildren.contains(child)) {
                    deepChildren.add(child);
                }
                child.getChildren(true).stream().filter(deepChild -> !deepChildren.contains(deepChild)).forEach(deepChildren::add);
            }
            return deepChildren;
        }
        return new ArrayList<CommandGroup>(this.children.values());
    }

    public void execute(String command, CommandSender sender, List<String> args) {
        Messenger messenger = this.plugin.getMessenger();
        CommandGroup entry = this.children.get(command.toLowerCase());
        if (entry instanceof Command) {
            if (!(entry.getMinArgsLength() > args.size() && entry.getMinArgsLength() != -1 || entry.getMaxArgsLength() < args.size() && entry.getMaxArgsLength() != -1)) {
                if (entry.getPermission() == null || sender.hasPermission(entry.getPermission())) {
                    if (sender instanceof Player || !entry.isPlayerOnly()) {
                        entry.execute(command, sender, args);
                    } else {
                        messenger.sendErrorMessage(sender, RelMessage.COMMAND_NOTAPLAYER, new Object[0]);
                    }
                } else {
                    messenger.sendErrorMessage(sender, RelMessage.COMMAND_NOPERMISSION, command);
                }
            } else {
                messenger.sendErrorMessage(sender, RelMessage.COMMAND_USAGE, ((Command)entry).getCommandUsage());
            }
        } else {
            String subCommand;
            String string = subCommand = args.size() == 0 ? "" : args.get(0);
            if (entry.hasChildCommand(subCommand)) {
                if (!args.isEmpty()) {
                    args.remove(0);
                }
                entry.execute(subCommand, sender, args);
            } else {
                messenger.sendErrorMessage(sender, RelMessage.COMMAND_INVALID, new Object[0]);
            }
        }
    }

    public List<String> tabComplete(List<String> args) {
        switch (args.size()) {
            case 1: {
                return CommandGroup.tabCompletions(args.get(0), this.tabCompleteList);
            }
        }
        return EMPTY_LIST;
    }

    public static List<String> tabCompletions(String arg, List<String> suggestions) {
        if (arg.isEmpty()) {
            return suggestions;
        }
        arg = arg.toLowerCase();
        ArrayList<String> modifiedList = new ArrayList<String>();
        for (String suggestion : suggestions) {
            if (!suggestion.toLowerCase().startsWith(arg)) continue;
            modifiedList.add(suggestion);
        }
        if (modifiedList.isEmpty()) {
            return suggestions;
        }
        return modifiedList;
    }
}

