/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.items.api.command;

import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.command.Command;
import com.herocraftonline.items.api.command.CommandGroup;
import com.herocraftonline.items.api.command.CommandPageList;
import com.herocraftonline.items.api.message.RelMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public class CommandController
implements TabExecutor {
    private ItemPlugin plugin;
    private Set<CommandGroup> commands = new LinkedHashSet<CommandGroup>();
    private CommandPageList pageList = null;

    public CommandController(ItemPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command cmd, String label, String[] args) {
        for (CommandGroup command : this.commands) {
            String subCommand;
            if (!command.getName().equalsIgnoreCase(cmd.getName())) continue;
            String string = subCommand = args.length > 0 ? args[0] : "";
            if (command.hasChildCommand(subCommand)) {
                ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
                if (!subCommand.isEmpty()) {
                    argsList.remove(0);
                }
                command.execute(subCommand, sender, argsList);
            } else {
                this.plugin.getMessenger().sendErrorMessage(sender, RelMessage.COMMAND_INVALID, new Object[0]);
            }
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, org.bukkit.command.Command cmd, String label, String[] args) {
        for (CommandGroup command : this.commands) {
            if (!command.getName().equalsIgnoreCase(cmd.getName()) || args.length <= 0) continue;
            int commandAmount = 0;
            for (String arg : args) {
                if (arg.isEmpty() || !command.hasChildCommand(arg)) continue;
                command = command.getChildCommand(arg);
                ++commandAmount;
            }
            if (command instanceof Command && args.length - commandAmount > command.getMaxArgsLength() || args.length <= commandAmount) continue;
            return command.tabComplete(Arrays.asList(args).subList(commandAmount, args.length));
        }
        return CommandGroup.EMPTY_LIST;
    }

    public Set<CommandGroup> getCommands() {
        return this.commands;
    }

    public void addCommand(CommandGroup command) {
        this.commands.add(command);
        String prefix = command.getPlugin().getDescription().getName().toLowerCase();
        String label = command.getName().toLowerCase();
        Bukkit.getServer().getPluginCommand(prefix + ":" + label).setExecutor((CommandExecutor)this);
    }

    public void removeCommand(CommandGroup command) {
        this.commands.remove(command);
        String prefix = command.getPlugin().getDescription().getName().toLowerCase();
        String label = command.getName().toLowerCase();
        Bukkit.getServer().getPluginCommand(prefix + ":" + label).setExecutor(null);
    }

    public void unregisterCommands() {
        for (CommandGroup command : this.commands) {
            String prefix = command.getPlugin().getDescription().getName().toLowerCase();
            String label = command.getName().toLowerCase();
            Bukkit.getServer().getPluginCommand(prefix + ":" + label).setExecutor(null);
        }
    }

    public CommandPageList getPageList() {
        return this.pageList;
    }

    public void updatePageList() {
        this.pageList = new CommandPageList(this.plugin);
    }
}

