/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroLeavePartyEvent;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.listeners.CustomDurabilityManager;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import com.herocraftonline.heroes.nms.physics.RayCastHit;
import com.herocraftonline.heroes.nms.physics.RayCastInfo;
import com.herocraftonline.heroes.util.GeometryUtil;
import com.herocraftonline.heroes.util.RegionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Fire;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public final class Util {
    public static final float DEFAULT_MINECRAFT_MOVEMENT_SPEED = 0.2f;
    public static final List<String> swords;
    public static final List<String> axes;
    public static final List<String> shovels;
    public static final List<String> picks;
    public static final List<String> hoes;
    public static final List<String> weapons;
    public static final List<String> placeableHelmets;
    public static final List<String> helmets;
    public static final List<String> chestPlates;
    public static final List<String> leggings;
    public static final List<String> boots;
    public static final List<String> armors;
    public static final List<String> tools;
    public static final List<String> trinkets;
    public static final List<String> toolsNotAlreadyWeapons;
    public static final Set<Material> interactableBlocks;
    public static final Set<Material> transparentBlocks;
    private static final Random rand;
    public static final Map<String, Location> deaths;
    public static final DecimalFormat smallDecFormat;
    public static final DecimalFormat decFormat;
    public static final DecimalFormat largeDecFormat;
    public static final DecimalFormat decFormatCDs;

    public static double getDefaultMaxHealth(LivingEntity entity) {
        switch (entity.getType().name()) {
            case "PIGLIN_BRUTE": {
                return 50.0;
            }
            case "HOGLIN": 
            case "ZOGLIN": {
                return 40.0;
            }
            case "ILLUSIONER": {
                return 32.0;
            }
            case "PILLAGER": {
                return 24.0;
            }
            case "PIG_ZOMBIE": 
            case "ZOMBIFIED_PIGLIN": 
            case "STRIDER": {
                return 20.0;
            }
            case "PIGLIN": {
                return 16.0;
            }
            case "BEE": {
                return 10.0;
            }
        }
        switch (entity.getType()) {
            case WITHER: {
                return 300.0;
            }
            case ENDER_DRAGON: {
                return 200.0;
            }
            case IRON_GOLEM: {
                return 100.0;
            }
            case ENDERMAN: {
                return 40.0;
            }
            case ELDER_GUARDIAN: {
                return 80.0;
            }
            case GUARDIAN: {
                return 30.0;
            }
            case WITCH: {
                return 26.0;
            }
            case VILLAGER: 
            case BLAZE: 
            case CREEPER: 
            case SKELETON: 
            case STRAY: 
            case WITHER_SKELETON: 
            case ZOMBIE: 
            case HUSK: 
            case DROWNED: 
            case PHANTOM: 
            case LLAMA: {
                return 20.0;
            }
            case SPIDER: {
                return 16.0;
            }
            case HORSE: 
            case DOLPHIN: 
            case MULE: 
            case EVOKER: 
            case VEX: 
            case VINDICATOR: 
            case POLAR_BEAR: 
            case SHULKER: {
                return 0.0;
            }
            case CAVE_SPIDER: {
                return 12.0;
            }
            case COW: 
            case MUSHROOM_COW: 
            case OCELOT: 
            case PIG: 
            case SQUID: 
            case SALMON: 
            case PUFFERFISH: 
            case TURTLE: 
            case TROPICAL_FISH: 
            case RABBIT: 
            case COD: {
                return 10.0;
            }
            case SHEEP: 
            case SILVERFISH: {
                return 8.0;
            }
            case BAT: 
            case PARROT: {
                return 6.0;
            }
            case SNOWMAN: {
                return 4.0;
            }
            case WOLF: {
                if (((Wolf)entity).isTamed()) {
                    return 20.0;
                }
                return 8.0;
            }
            case SLIME: 
            case MAGMA_CUBE: {
                int size = ((Slime)entity).getSize();
                return Math.pow(size, 2.0);
            }
        }
        return 0.0;
    }

    public static double getDefaultDamage(Material item) {
        switch (item) {
            case WOODEN_PICKAXE: 
            case GOLDEN_PICKAXE: {
                return 2.0;
            }
            case STONE_PICKAXE: {
                return 3.0;
            }
            case STONE_SHOVEL: {
                return 3.5;
            }
            case WOODEN_SWORD: 
            case GOLDEN_SWORD: 
            case IRON_PICKAXE: 
            case BOW: {
                return 4.0;
            }
            case IRON_SHOVEL: {
                return 4.5;
            }
            case DIAMOND_SHOVEL: {
                return 5.5;
            }
            case DIAMOND_PICKAXE: 
            case STONE_SWORD: {
                return 5.0;
            }
            case IRON_SWORD: {
                return 6.0;
            }
            case WOODEN_AXE: 
            case GOLDEN_AXE: 
            case DIAMOND_SWORD: {
                return 7.0;
            }
            case STONE_AXE: 
            case IRON_AXE: 
            case DIAMOND_AXE: {
                return 9.0;
            }
            case TRIDENT: {
                return 9.0;
            }
        }
        return NMSHandler.getInterface().getDefaultDamage(item);
    }

    public static boolean leaveParty(Heroes plugin, Hero hero, HeroLeavePartyEvent.LeavePartyReason leaveReason) {
        Player player = hero.getPlayer();
        HeroParty heroParty = hero.getParty();
        if (heroParty == null) {
            player.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "You don't have a party!");
            return false;
        }
        HeroLeavePartyEvent event = new HeroLeavePartyEvent(hero, heroParty, leaveReason);
        plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            player.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "You can not leave the party at this time!");
            return false;
        }
        heroParty.messageParty(player.getName() + ChatColor.GRAY + " has left the party");
        heroParty.removeMember(hero);
        if (heroParty.getMembers().size() == 0) {
            plugin.getPartyManager().removeParty(heroParty);
        }
        hero.setParty(null);
        return true;
    }

    public static float convertPercentageToPlayerMovementSpeedValue(double percentage) {
        return Util.convertPercentageToPlayerMovementSpeedValue((float)percentage);
    }

    public static float convertPercentageToPlayerMovementSpeedValue(float percentage) {
        return 0.2f * percentage;
    }

    public static boolean isUndead(Heroes plugin, LivingEntity entity) {
        if (entity instanceof Zombie || entity instanceof Skeleton || entity instanceof PigZombie || entity instanceof Ghast) {
            return true;
        }
        if (entity instanceof Player) {
            Hero hero = plugin.getCharacterManager().getHero((Player)entity);
            boolean isUndead = false;
            for (Effect effect : hero.getEffects()) {
                if (!"Undead".equals(effect.getName()) && !"BecomeDeath".equals(effect.getName())) continue;
                isUndead = true;
            }
            return isUndead;
        }
        return false;
    }

    public static boolean isNearSpawner(Entity entity, int radius) {
        Location location = entity.getLocation();
        for (int i = 0 - radius; i <= radius; ++i) {
            for (int j = 0 - radius; j <= radius; ++j) {
                for (int k = 0 - radius; k <= radius; ++k) {
                    String type = location.getBlock().getRelative(i, j, k).getType().toString();
                    if (!type.equals("MOB_SPAWNER") && !type.equals("SPAWNER")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Deprecated
    public static void playClientEffect(Player player, String particle, Vector offset, float speed, int count, boolean sendToAll) {
        Util.playClientEffect(player, player.getLocation(), particle, offset, speed, count, sendToAll);
    }

    @Deprecated
    public static void playClientEffect(Player player, Location startLocation, String particle, Vector offset, float speed, int count, boolean sendToAll) {
        NMSHandler.getInterface().playClientEffect(player, startLocation, particle, offset, speed, count, sendToAll);
    }

    @Deprecated
    public static List<Location> getCircleLocationList(Location startingLocation, Integer radius, Integer height, boolean isHollow, boolean isSphere, int plus_y) {
        return GeometryUtil.getPerfectCircle(startingLocation, radius, height, isHollow, isSphere, plus_y);
    }

    public static boolean isInBorder(Location center, Location targetLocation, int radiusX, int radiusY, int radiusZ) {
        int x1 = center.getBlockX();
        int y1 = center.getBlockY();
        int z1 = center.getBlockZ();
        int x2 = targetLocation.getBlockX();
        int y2 = targetLocation.getBlockY();
        int z2 = targetLocation.getBlockZ();
        return x2 < x1 + radiusX && x2 > x1 - radiusX && y2 < y1 + radiusY && y2 > y1 - radiusY && z2 < z1 + radiusZ && z2 > z1 - radiusZ;
    }

    public static boolean manuallyDamageWeaponDurability(Player player, int damage) {
        ItemStack mainHandItem = NMSHandler.getInterface().getItemInMainHand(player.getInventory());
        if (mainHandItem == null || mainHandItem.getType() == Material.AIR) {
            return false;
        }
        if (!weapons.contains(mainHandItem.getType().name())) {
            return false;
        }
        return Util.manuallyDamageItemDurability(player, mainHandItem, damage);
    }

    public static boolean manuallyDamageItemDurability(Player player, ItemStack item, int damage) {
        if (item == null || item.getType().getMaxDurability() < 1) {
            return false;
        }
        PlayerItemDamageEvent itemDamageEvent = new PlayerItemDamageEvent(player, item, damage);
        Heroes.getInstance().getServer().getPluginManager().callEvent((Event)itemDamageEvent);
        if (itemDamageEvent.isCancelled()) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemDamageEvent.getDamage() > 0 && !itemMeta.isUnbreakable()) {
            if (Heroes.properties.customDurabilityEnabled && !Heroes.properties.syncWithMinecraftDurability) {
                return true;
            }
            short newDamage = (short)(item.getDurability() + itemDamageEvent.getDamage());
            if (newDamage > item.getType().getMaxDurability()) {
                Util.forcefullyBreakItem(item);
            } else if (itemMeta instanceof Damageable) {
                ((Damageable)itemMeta).setDamage((int)newDamage);
                item.setItemMeta(itemMeta);
            }
        }
        return true;
    }

    public static void forcefullyBreakItem(ItemStack item) {
        if (item == null) {
            return;
        }
        item.setAmount(item.getAmount() - 1);
        if (item.getAmount() < 1) {
            item.setType(Material.AIR);
        }
    }

    public static boolean repairItem(ItemStack item) {
        return Util.repairItem(null, item);
    }

    public static boolean repairItem(@Nullable Heroes plugin, ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return Util.repairItem(plugin, item, item.getItemMeta());
    }

    public static boolean repairItem(@Nullable Heroes plugin, ItemStack item, ItemMeta itemMeta) {
        CustomDurabilityManager customDurabilityManager;
        CustomDurabilityManager customDurabilityManager2 = customDurabilityManager = plugin != null ? plugin.getCustomDurabilityManager() : null;
        if (customDurabilityManager != null) {
            return customDurabilityManager.repairItem(item, itemMeta);
        }
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        if (itemMeta instanceof Damageable) {
            ((Damageable)itemMeta).setDamage(0);
            return item.setItemMeta(itemMeta);
        }
        return false;
    }

    public static int getFirstEmptyInStorageSlot(PlayerInventory inventory) {
        ItemStack[] contents = inventory.getStorageContents();
        for (int i = 9; i < contents.length; ++i) {
            if (contents[i] != null && contents[i].getType() != Material.AIR) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public static int firstEmpty(ItemStack[] inventory) {
        for (int i = 9; i < inventory.length; ++i) {
            if (inventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    public static boolean moveItem(Hero hero, int slot, ItemStack item) {
        if (item == null) {
            return true;
        }
        Player player = hero.getPlayer();
        return Util.moveItem(player, slot, item);
    }

    public static boolean moveItem(Player player, int slot, ItemStack item) {
        if (item == null) {
            return true;
        }
        PlayerInventory inv = player.getInventory();
        int empty = Util.getFirstEmptyInStorageSlot(inv);
        if (empty == -1) {
            player.getWorld().dropItemNaturally(player.getLocation(), item);
            if (slot != -1) {
                inv.clear(slot);
            }
            return false;
        }
        inv.setItem(empty, item);
        if (slot != -1) {
            inv.clear(slot);
        }
        return true;
    }

    public static Vector calculateDifferentialKnockback(LivingEntity target, LivingEntity attacker, float knockbackStrength) {
        Location attackerLoc = attacker.getLocation();
        Location targetLoc = target.getLocation();
        double d0 = attackerLoc.getX() - targetLoc.getX();
        double d1 = attackerLoc.getZ() - targetLoc.getZ();
        while (d0 * d0 + d1 * d1 < 1.0E-4) {
            d0 = (Math.random() - Math.random()) * 0.01;
            d1 = (Math.random() - Math.random()) * 0.01;
        }
        Vector initialVec = target.getVelocity();
        Vector postVec = new Vector(d0, 0.0, d1);
        postVec = postVec.length() < 1.0E-4 ? new Vector() : postVec.normalize();
        postVec.multiply(knockbackStrength -= (knockbackStrength = (float)((double)knockbackStrength * (1.0 - target.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE).getValue()))) < 0.5f ? 0.5f : 0.25f);
        return new Vector(initialVec.getX() / 2.0 - postVec.getX(), target.isOnGround() ? Math.min(0.4, initialVec.getY() / 2.0 + (double)(knockbackStrength < 0.0f ? 0.0f : knockbackStrength)) : initialVec.getY(), initialVec.getZ() / 2.0 - postVec.getZ());
    }

    public static void syncInventory(final Player player, Heroes plugin) {
        plugin.getServer().getScheduler().runTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                player.updateInventory();
            }
        });
    }

    @Nullable
    public static LivingEntity getTargetAtDistance(Heroes plugin, NMSPhysics physics, Hero hero, float distance) {
        LivingEntity target = null;
        Player player = hero.getPlayer();
        World world = player.getWorld();
        Location eyeLocation = player.getEyeLocation();
        Vector normal = eyeLocation.getDirection();
        Vector start = eyeLocation.toVector();
        Vector end = normal.clone().multiply(distance).add(start);
        RayCastInfo rayCastInfo = new RayCastInfo();
        rayCastInfo.setBlockFilter(b -> true);
        rayCastInfo.setEntityFilter(Util.getTargetFilter(plugin, hero));
        RayCastHit hit = physics.rayCast(world, (Entity)player, start, end, rayCastInfo);
        if (hit != null && hit.isEntity()) {
            target = (LivingEntity)hit.getEntity();
        }
        return target;
    }

    private static Predicate<Entity> getTargetFilter(final Heroes plugin, final Hero hero) {
        return new Predicate<Entity>(){

            @Override
            public boolean test(Entity possibleTarget) {
                HumanEntity humanTarget;
                if (possibleTarget instanceof ArmorStand) {
                    return false;
                }
                if (possibleTarget instanceof HumanEntity && ((humanTarget = (HumanEntity)possibleTarget).getGameMode() == GameMode.SPECTATOR || humanTarget.getGameMode() == GameMode.CREATIVE)) {
                    return false;
                }
                if (possibleTarget instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)possibleTarget;
                    if (target.isDead() || target.getHealth() == 0.0) {
                        return false;
                    }
                    CharacterTemplate targetCharacter = plugin.getCharacterManager().getCharacter(target);
                    if (targetCharacter.hasEffectType(EffectType.UNTARGETABLE)) {
                        return false;
                    }
                    return !hero.isAlliedTo(target);
                }
                return true;
            }
        };
    }

    public static boolean isWeapon(Material mat) {
        return weapons.contains(mat.name()) || Heroes.properties.useToolsInPermittedWeapons && toolsNotAlreadyWeapons.contains(mat.name());
    }

    public static boolean isAwkwardWeapon(Material mat) {
        switch (mat.name()) {
            case "MUSIC_DISC_PIGSTEP": {
                return true;
            }
        }
        switch (mat) {
            case NOTE_BLOCK: 
            case JUKEBOX: 
            case MUSIC_DISC_11: 
            case MUSIC_DISC_13: 
            case MUSIC_DISC_BLOCKS: 
            case MUSIC_DISC_CAT: 
            case MUSIC_DISC_CHIRP: 
            case MUSIC_DISC_FAR: 
            case MUSIC_DISC_MALL: 
            case MUSIC_DISC_MELLOHI: 
            case MUSIC_DISC_STAL: 
            case MUSIC_DISC_STRAD: 
            case MUSIC_DISC_WAIT: 
            case MUSIC_DISC_WARD: 
            case STICK: 
            case COD: 
            case PUFFERFISH: 
            case SALMON: 
            case TROPICAL_FISH: 
            case BLAZE_ROD: {
                return true;
            }
        }
        return false;
    }

    public static boolean isArmor(Material mat) {
        return armors.contains(mat.name());
    }

    public static boolean isTrinket(Material mat) {
        switch (mat.name()) {
            case "WARPED_FUNGUS_ON_A_STICK": {
                return true;
            }
        }
        switch (mat) {
            case BLAZE_ROD: 
            case SHIELD: 
            case FISHING_ROD: 
            case CARROT_ON_A_STICK: 
            case PAPER: 
            case BOOK: 
            case LEAD: 
            case CLOCK: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static ItemStack safelyGetItemInOffhand(Player player) {
        return NMSHandler.getInterface().getItemInOffHand(player.getInventory());
    }

    @Nullable
    public static ItemStack safelyGetItemInOffhand(PlayerInventory inventory) {
        return NMSHandler.getInterface().getItemInOffHand(inventory);
    }

    public static void safelySetItemInOffhand(PlayerInventory inventory, ItemStack item) {
        NMSHandler.getInterface().setItemInOffHand(inventory, item);
    }

    public static boolean disarmCheck(Hero hero, Heroes plugin) {
        ItemStack[] contents = hero.getPlayer().getInventory().getContents();
        boolean changed = false;
        for (int i = 0; i < 9; ++i) {
            if (contents[i] == null || !Util.isWeapon(contents[i].getType())) continue;
            Util.moveItem(hero, i, contents[i]);
            changed = true;
        }
        if (changed) {
            Util.syncInventory(hero.getPlayer(), plugin);
        }
        return changed;
    }

    public static void setBlocksOnFireIfAble(Iterable<Block> blocks) {
        for (Block block : blocks) {
            Util.setBlockOnFireIfAble(block, 1.0, true);
        }
    }

    public static void setBlocksOnFireIfAble(Iterable<Block> blocks, boolean validateCanPvP) {
        if (validateCanPvP) {
            for (Block block : blocks) {
                Util.setBlockOnFireIfAble(block, 1.0, true);
            }
        } else {
            for (Block block : blocks) {
                Util.setBlockOnFireIfAble(block, 1.0, false);
            }
        }
    }

    public static void setBlocksOnFireIfAble(Iterable<Block> blocks, double lifetimePercentModifier) {
        for (Block block : blocks) {
            Util.setBlockOnFireIfAble(block, lifetimePercentModifier, true);
        }
    }

    public static void setBlocksOnFireIfAble(Iterable<Block> blocks, double lifetimePercentModifier, boolean validateCanPvP) {
        if (validateCanPvP) {
            for (Block block : blocks) {
                Util.setBlockOnFireIfAble(block, lifetimePercentModifier, true);
            }
        } else {
            for (Block block : blocks) {
                Util.setBlockOnFireIfAble(block, lifetimePercentModifier, false);
            }
        }
    }

    public static void setBlockOnFireIfAble(Block block) {
        Util.setBlockOnFireIfAble(block, 1.0, true);
    }

    public static void setBlockOnFireIfAble(Block block, boolean validateCanPvP) {
        Util.setBlockOnFireIfAble(block, 1.0, validateCanPvP);
    }

    public static void setBlockOnFireIfAble(Block block, double lifetimePercentModifier) {
        Util.setBlockOnFireIfAble(block, lifetimePercentModifier, true);
    }

    public static void setBlockOnFireIfAble(Block block, double lifetimePercentModifier, boolean validateCanPvP) {
        if (block == null || !block.isEmpty()) {
            return;
        }
        if (validateCanPvP && RegionUtil.IsNoPvPRegion(block.getLocation())) {
            return;
        }
        Util.setBlockOnFire(block, lifetimePercentModifier);
    }

    private static void setBlockOnFire(final Block block, double lifetimePercentModifier) {
        block.setType(Material.FIRE);
        Fire blockData = (Fire)Material.FIRE.createBlockData();
        int maxFireAge = 15;
        int ticksBeforeAgeCheck = 4;
        double fireAgeDecreaseChance = 3.33;
        double averageDurationTicks = 199.8;
        Material belowType = block.getRelative(BlockFace.DOWN).getType();
        boolean isBelowFlammable = belowType.isBurnable() || belowType == Material.NETHERRACK;
        boolean isAboveFlammable = block.getRelative(BlockFace.UP).getType().isBurnable();
        boolean isEastFlammable = block.getRelative(BlockFace.EAST).getType().isBurnable();
        boolean isWestFlammable = block.getRelative(BlockFace.WEST).getType().isBurnable();
        boolean isNorthFlammable = block.getRelative(BlockFace.NORTH).getType().isBurnable();
        boolean isSouthFlammable = block.getRelative(BlockFace.SOUTH).getType().isBurnable();
        if (!isBelowFlammable) {
            if (isAboveFlammable) {
                blockData.setFace(BlockFace.UP, true);
            } else if (isEastFlammable) {
                blockData.setFace(BlockFace.EAST, true);
            } else if (isWestFlammable) {
                blockData.setFace(BlockFace.WEST, true);
            } else if (isNorthFlammable) {
                blockData.setFace(BlockFace.NORTH, true);
            } else if (isSouthFlammable) {
                blockData.setFace(BlockFace.SOUTH, true);
            }
        }
        if (isBelowFlammable || isAboveFlammable || isEastFlammable || isWestFlammable || isNorthFlammable || isSouthFlammable) {
            int burnTicks = (int)(199.8 * lifetimePercentModifier);
            new BukkitRunnable(){

                public void run() {
                    if (block.getType() == Material.FIRE) {
                        block.setType(Material.AIR);
                    }
                }
            }.runTaskLater((Plugin)Heroes.getInstance(), (long)burnTicks);
        } else if (lifetimePercentModifier > 0.0 && lifetimePercentModifier < 1.0) {
            int burnDurationAsVanillaFireAge = 15 - (int)(199.8 * lifetimePercentModifier / 4.0 / 3.33);
            blockData.setAge(burnDurationAsVanillaFireAge);
        }
        block.setBlockData((BlockData)blockData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveFile(File from, File to) {
        if (!from.exists()) {
            return;
        }
        OutputStream output = null;
        InputStream input = null;
        try {
            int out;
            to.getParentFile().mkdirs();
            to.createNewFile();
            output = new FileOutputStream(to, false);
            input = new FileInputStream(from);
            while ((out = input.read()) != -1) {
                output.write(out);
            }
            input.close();
            output.close();
            from.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static int getMCExperience(int level) {
        return level * 7;
    }

    public static Integer toInt(Object val) {
        if (val instanceof String) {
            try {
                return Integer.valueOf((String)val);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (!(val instanceof Number)) {
            return null;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Double) {
            return ((Double)val).intValue();
        }
        if (val instanceof Float) {
            return ((Float)val).intValue();
        }
        if (val instanceof Long) {
            return ((Long)val).intValue();
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).intValue();
        }
        return null;
    }

    public static int toInt(Object val, int def) {
        Integer i = Util.toInt(val);
        return i != null ? i : def;
    }

    public static int toIntNonNull(Object val, String name) {
        Integer newVal = Util.toInt(val);
        if (newVal == null) {
            throw new IllegalArgumentException(name + " must be a numeral!");
        }
        return newVal;
    }

    public static double toDoubleNonNull(Object val, String name) {
        Double newVal = Util.toDouble(val);
        if (newVal == null) {
            throw new IllegalArgumentException(name + " must be a numeral!");
        }
        return newVal;
    }

    public static float toFloatNonNull(Object val, String name) {
        Float newVal = Util.toFloat(val);
        if (newVal == null) {
            throw new IllegalArgumentException(name + " must be a numeral!");
        }
        return newVal.floatValue();
    }

    public static boolean isFood(Material mat) {
        return NMSHandler.getInterface().isFood(mat);
    }

    public static int getFoodValue(Material type) {
        return NMSHandler.getInterface().getFoodValue(type);
    }

    public static Double toDouble(Object val) {
        if (val instanceof String) {
            try {
                return Double.valueOf((String)val);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (!(val instanceof Number)) {
            return null;
        }
        if (val instanceof Integer) {
            return ((Integer)val).doubleValue();
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Float) {
            return ((Float)val).doubleValue();
        }
        if (val instanceof Long) {
            return ((Long)val).doubleValue();
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).doubleValue();
        }
        return null;
    }

    public static double toDouble(Object val, double def) {
        Double d = Util.toDouble(val);
        return d != null ? d : def;
    }

    public static Float toFloat(Object val) {
        if (val instanceof String) {
            try {
                return Float.valueOf((String)val);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (!(val instanceof Number)) {
            return null;
        }
        if (val instanceof Integer) {
            return Float.valueOf(((Integer)val).floatValue());
        }
        if (val instanceof Double) {
            return Float.valueOf(((Double)val).floatValue());
        }
        if (val instanceof Float) {
            return (Float)val;
        }
        if (val instanceof Long) {
            return Float.valueOf(((Long)val).floatValue());
        }
        if (val instanceof BigDecimal) {
            return Float.valueOf(((BigDecimal)val).floatValue());
        }
        return null;
    }

    public static float toFloat(Object val, float def) {
        Float f = Util.toFloat(val);
        return f != null ? f.floatValue() : def;
    }

    public static String stringDouble(double d) {
        return String.valueOf(Util.formatDouble(d));
    }

    public static double formatDouble(double d) {
        int val = (int)(d * 1000.0);
        return (double)val / 1000.0;
    }

    public static ItemStack itemFromString(String[] vals, int amount) {
        ItemStack stack = null;
        try {
            Material material;
            byte sub = 0;
            if (vals.length > 1) {
                sub = (byte)Integer.parseInt(vals[1]);
            }
            if ((material = Material.matchMaterial((String)vals[0])) == null) {
                Heroes.log(Level.SEVERE, "Invalid item material name \"" + vals[0] + "\" to retrieve item from string. Please switch to new format NAME:damage, e.g. IRON_INGOT:1, where damage is optional.");
            } else {
                stack = new ItemStack(material, amount, (short)sub);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return stack;
    }

    public static int getFeatherFallLevel(PlayerInventory inv) {
        int level = 0;
        for (ItemStack armor : inv.getArmorContents()) {
            if (armor == null || !armor.containsEnchantment(Enchantment.PROTECTION_FALL)) continue;
            level += armor.getEnchantmentLevel(Enchantment.PROTECTION_FALL);
        }
        return level;
    }

    public static double nextRand() {
        return (double)rand.nextInt(10000) / 10000.0;
    }

    public static int nextInt(int max) {
        return rand.nextInt(max);
    }

    public static Set<Entity> getChunkEntities(World world, int blockMinX, int blockMaxX, int blockMinZ, int blockMaxZ) {
        HashSet<Entity> entities = new HashSet<Entity>();
        int chunkMaxX = blockMaxX >> 4;
        int chunkMaxZ = blockMaxZ >> 4;
        for (int x = blockMinX >> 4; x <= chunkMaxX; ++x) {
            for (int z = blockMinZ >> 4; z <= chunkMaxZ; ++z) {
                Collections.addAll(entities, world.getChunkAt(x, z).getEntities());
            }
        }
        return entities;
    }

    public static Set<Entity> getChunkEntities(Block block, int blockBoundsX, int blockBoundsZ) {
        return Util.getChunkEntities(block.getWorld(), block.getX() - blockBoundsX, block.getX() + blockBoundsX, block.getZ() - blockBoundsZ, block.getZ() + blockBoundsZ);
    }

    public static Set<Entity> getChunkEntities(Location location, int blockBoundsX, int blockBoundsZ) {
        return Util.getChunkEntities(location.getWorld(), location.getBlockX() - blockBoundsX, location.getBlockX() + blockBoundsX, location.getBlockZ() - blockBoundsZ, location.getBlockZ() + blockBoundsZ);
    }

    static {
        rand = new SecureRandom();
        smallDecFormat = new DecimalFormat("#0.#");
        decFormat = new DecimalFormat("#0.##");
        largeDecFormat = new DecimalFormat("#0.###");
        decFormatCDs = new DecimalFormat("#0.0");
        swords = new ArrayList<String>();
        swords.add("WOODEN_SWORD");
        swords.add("STONE_SWORD");
        swords.add("IRON_SWORD");
        swords.add("GOLDEN_SWORD");
        swords.add("DIAMOND_SWORD");
        swords.add("NETHERITE_SWORD");
        axes = new ArrayList<String>();
        axes.add("WOODEN_AXE");
        axes.add("STONE_AXE");
        axes.add("IRON_AXE");
        axes.add("GOLDEN_AXE");
        axes.add("DIAMOND_AXE");
        axes.add("NETHERITE_AXE");
        shovels = new ArrayList<String>();
        shovels.add("WOODEN_SPADE");
        shovels.add("WOODEN_SHOVEL");
        shovels.add("STONE_SPADE");
        shovels.add("STONE_SHOVEL");
        shovels.add("IRON_SPADE");
        shovels.add("IRON_SHOVEL");
        shovels.add("GOLDEN_SPADE");
        shovels.add("GOLDEN_SHOVEL");
        shovels.add("DIAMOND_SPADE");
        shovels.add("DIAMOND_SHOVEL");
        shovels.add("NETHERITE_SHOVEL");
        picks = new ArrayList<String>();
        picks.add("WOODEN_PICKAXE");
        picks.add("STONE_PICKAXE");
        picks.add("IRON_PICKAXE");
        picks.add("GOLDEN_PICKAXE");
        picks.add("DIAMOND_PICKAXE");
        picks.add("NETHERITE_PICKAXE");
        hoes = new ArrayList<String>();
        hoes.add("WOODEN_HOE");
        hoes.add("STONE_HOE");
        hoes.add("IRON_HOE");
        hoes.add("GOLDEN_HOE");
        hoes.add("DIAMOND_HOE");
        hoes.add("NETHERITE_HOE");
        tools = new ArrayList<String>();
        tools.add("SHEARS");
        tools.add("FISHING_ROD");
        tools.add("CARROT_STICK");
        tools.add("WARPED_FUNGUS_ON_A_STICK");
        tools.addAll(picks);
        tools.addAll(axes);
        tools.addAll(shovels);
        tools.addAll(hoes);
        weapons = new ArrayList<String>();
        weapons.addAll(swords);
        weapons.addAll(axes);
        weapons.addAll(shovels);
        weapons.addAll(hoes);
        weapons.add("BOW");
        weapons.add("TRIDENT");
        weapons.add("CROSSBOW");
        weapons.add("SHIELD");
        weapons.add("TOTEM_OF_UNDYING");
        toolsNotAlreadyWeapons = new ArrayList<String>();
        toolsNotAlreadyWeapons.addAll(picks);
        toolsNotAlreadyWeapons.add("SHEARS");
        toolsNotAlreadyWeapons.add("FISHING_ROD");
        toolsNotAlreadyWeapons.add("CARROT_STICK");
        toolsNotAlreadyWeapons.add("WARPED_FUNGUS_ON_A_STICK");
        placeableHelmets = new ArrayList<String>();
        placeableHelmets.add("PUMPKIN");
        placeableHelmets.add("SKULL_ITEM");
        placeableHelmets.add("WITHER_SKELETON_SKULL");
        placeableHelmets.add("SKELETON_SKULL");
        placeableHelmets.add("CREEPER_HEAD");
        placeableHelmets.add("ZOMBIE_HEAD");
        placeableHelmets.add("DRAGON_HEAD");
        placeableHelmets.add("PLAYER_HEAD");
        helmets = new ArrayList<String>();
        helmets.add("LEATHER_HELMET");
        helmets.add("GOLDEN_HELMET");
        helmets.add("CHAINMAIL_HELMET");
        helmets.add("IRON_HELMET");
        helmets.add("DIAMOND_HELMET");
        helmets.add("NETHERITE_HELMET");
        helmets.add("TURTLE_SHELL");
        helmets.add("TURTLE_HELMET");
        helmets.add("PUMPKIN");
        helmets.add("SKULL_ITEM");
        helmets.add("WITHER_SKELETON_SKULL");
        helmets.add("SKELETON_SKULL");
        helmets.add("CREEPER_HEAD");
        helmets.add("ZOMBIE_HEAD");
        helmets.add("DRAGON_HEAD");
        helmets.add("PLAYER_HEAD");
        chestPlates = new ArrayList<String>();
        chestPlates.add("ELYTRA");
        chestPlates.add("LEATHER_CHESTPLATE");
        chestPlates.add("GOLDEN_CHESTPLATE");
        chestPlates.add("CHAINMAIL_CHESTPLATE");
        chestPlates.add("IRON_CHESTPLATE");
        chestPlates.add("DIAMOND_CHESTPLATE");
        chestPlates.add("NETHERITE_CHESTPLATE");
        leggings = new ArrayList<String>();
        leggings.add("LEATHER_LEGGINGS");
        leggings.add("GOLDEN_LEGGINGS");
        leggings.add("CHAINMAIL_LEGGINGS");
        leggings.add("IRON_LEGGINGS");
        leggings.add("DIAMOND_LEGGINGS");
        leggings.add("NETHERITE_LEGGINGS");
        boots = new ArrayList<String>();
        boots.add("LEATHER_BOOTS");
        boots.add("IRON_BOOTS");
        boots.add("CHAINMAIL_BOOTS");
        boots.add("GOLDEN_BOOTS");
        boots.add("DIAMOND_BOOTS");
        boots.add("NETHERITE_BOOTS");
        armors = new ArrayList<String>();
        armors.addAll(helmets);
        armors.addAll(chestPlates);
        armors.addAll(leggings);
        armors.addAll(boots);
        trinkets = new ArrayList<String>();
        trinkets.add("SHIELD");
        trinkets.add("BLAZE_ROD");
        trinkets.add("PAPER");
        trinkets.add("BOOK");
        trinkets.add("LEASH");
        trinkets.add("LEAD");
        trinkets.add("WATCH");
        trinkets.add("CLOCK");
        interactableBlocks = EnumSet.noneOf(Material.class);
        for (Material mat : Material.values()) {
            if (!mat.isInteractable() && !Tag.ITEMS_BOATS.isTagged((Keyed)mat) && !mat.toString().contains("MINECART") && !mat.toString().contains("SIGN")) continue;
            interactableBlocks.add(mat);
        }
        interactableBlocks.add(Material.ITEM_FRAME);
        transparentBlocks = EnumSet.noneOf(Material.class);
        for (Material mat : Material.values()) {
            if (!mat.toString().contains("SIGN")) continue;
            transparentBlocks.add(mat);
        }
        transparentBlocks.add(Material.AIR);
        transparentBlocks.add(Material.CAVE_AIR);
        transparentBlocks.add(Material.VOID_AIR);
        transparentBlocks.add(Material.FIRE);
        transparentBlocks.add(Material.BLACK_CARPET);
        transparentBlocks.add(Material.BLUE_CARPET);
        transparentBlocks.add(Material.BROWN_CARPET);
        transparentBlocks.add(Material.CYAN_CARPET);
        transparentBlocks.add(Material.GRAY_CARPET);
        transparentBlocks.add(Material.GREEN_CARPET);
        transparentBlocks.add(Material.LIGHT_BLUE_CARPET);
        transparentBlocks.add(Material.LIGHT_GRAY_CARPET);
        transparentBlocks.add(Material.LIME_CARPET);
        transparentBlocks.add(Material.MAGENTA_CARPET);
        transparentBlocks.add(Material.ORANGE_CARPET);
        transparentBlocks.add(Material.PINK_CARPET);
        transparentBlocks.add(Material.PURPLE_CARPET);
        transparentBlocks.add(Material.RED_CARPET);
        transparentBlocks.add(Material.WHITE_CARPET);
        transparentBlocks.add(Material.YELLOW_CARPET);
        transparentBlocks.add(Material.DEAD_BUSH);
        transparentBlocks.add(Material.REPEATER);
        transparentBlocks.add(Material.ACACIA_FENCE_GATE);
        transparentBlocks.add(Material.BIRCH_FENCE_GATE);
        transparentBlocks.add(Material.DARK_OAK_FENCE_GATE);
        transparentBlocks.add(Material.JUNGLE_FENCE_GATE);
        transparentBlocks.add(Material.OAK_FENCE_GATE);
        transparentBlocks.add(Material.SPRUCE_FENCE_GATE);
        transparentBlocks.add(Material.FLOWER_POT);
        transparentBlocks.add(Material.LADDER);
        transparentBlocks.add(Material.LEVER);
        transparentBlocks.add(Material.NETHER_WART_BLOCK);
        transparentBlocks.add(Material.NETHER_PORTAL);
        transparentBlocks.add(Material.END_PORTAL);
        transparentBlocks.add(Material.RAIL);
        transparentBlocks.add(Material.ACTIVATOR_RAIL);
        transparentBlocks.add(Material.DETECTOR_RAIL);
        transparentBlocks.add(Material.POWERED_RAIL);
        transparentBlocks.add(Material.POPPY);
        transparentBlocks.add(Material.ROSE_BUSH);
        transparentBlocks.add(Material.COMPARATOR);
        transparentBlocks.add(Material.REDSTONE_TORCH);
        transparentBlocks.add(Material.REDSTONE_WALL_TORCH);
        transparentBlocks.add(Material.REDSTONE_WIRE);
        transparentBlocks.add(Material.ACACIA_SAPLING);
        transparentBlocks.add(Material.BIRCH_SAPLING);
        transparentBlocks.add(Material.DARK_OAK_SAPLING);
        transparentBlocks.add(Material.JUNGLE_SAPLING);
        transparentBlocks.add(Material.OAK_SAPLING);
        transparentBlocks.add(Material.SPRUCE_SAPLING);
        transparentBlocks.add(Material.SNOW);
        transparentBlocks.add(Material.LAVA);
        transparentBlocks.add(Material.STONE_BUTTON);
        transparentBlocks.add(Material.STONE_PRESSURE_PLATE);
        transparentBlocks.add(Material.SUGAR_CANE);
        transparentBlocks.add(Material.TORCH);
        transparentBlocks.add(Material.WALL_TORCH);
        transparentBlocks.add(Material.TRIPWIRE);
        transparentBlocks.add(Material.VINE);
        transparentBlocks.add(Material.LILY_PAD);
        transparentBlocks.add(Material.WATER);
        transparentBlocks.add(Material.COBWEB);
        transparentBlocks.add(Material.ACACIA_BUTTON);
        transparentBlocks.add(Material.BIRCH_BUTTON);
        transparentBlocks.add(Material.DARK_OAK_BUTTON);
        transparentBlocks.add(Material.JUNGLE_BUTTON);
        transparentBlocks.add(Material.OAK_BUTTON);
        transparentBlocks.add(Material.SPRUCE_BUTTON);
        transparentBlocks.add(Material.ACACIA_PRESSURE_PLATE);
        transparentBlocks.add(Material.BIRCH_PRESSURE_PLATE);
        transparentBlocks.add(Material.DARK_OAK_PRESSURE_PLATE);
        transparentBlocks.add(Material.JUNGLE_PRESSURE_PLATE);
        transparentBlocks.add(Material.OAK_PRESSURE_PLATE);
        transparentBlocks.add(Material.SPRUCE_PRESSURE_PLATE);
        transparentBlocks.add(Material.LIGHT_WEIGHTED_PRESSURE_PLATE);
        transparentBlocks.add(Material.HEAVY_WEIGHTED_PRESSURE_PLATE);
        transparentBlocks.add(Material.DANDELION);
        transparentBlocks.add(Material.OXEYE_DAISY);
        transparentBlocks.add(Material.AZURE_BLUET);
        transparentBlocks.add(Material.BLUE_ORCHID);
        transparentBlocks.add(Material.ALLIUM);
        transparentBlocks.add(Material.ORANGE_TULIP);
        transparentBlocks.add(Material.PINK_TULIP);
        transparentBlocks.add(Material.RED_TULIP);
        transparentBlocks.add(Material.WHITE_TULIP);
        transparentBlocks.add(Material.SUNFLOWER);
        transparentBlocks.add(Material.LILAC);
        transparentBlocks.add(Material.PEONY);
        transparentBlocks.add(Material.GRASS);
        transparentBlocks.add(Material.TALL_GRASS);
        transparentBlocks.add(Material.SEAGRASS);
        transparentBlocks.add(Material.TALL_SEAGRASS);
        transparentBlocks.add(Material.WHEAT_SEEDS);
        transparentBlocks.add(Material.MELON_SEEDS);
        transparentBlocks.add(Material.PUMPKIN_SEEDS);
        transparentBlocks.add(Material.BEETROOT_SEEDS);
        deaths = new LinkedHashMap<String, Location>(){
            private static final long serialVersionUID = 232555501115853225L;
            private static final int MAX_ENTRIES = 50;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Location> eldest) {
                return this.size() > 50;
            }
        };
    }

    public static enum DefaultItemTypes {
        WOODEN_SWORD,
        WOODEN_AXE,
        WOODEN_PICKAXE,
        WOODEN_SHOVEL,
        STONE_SWORD,
        STONE_AXE,
        STONE_PICKAXE,
        STONE_SHOVEL,
        GOLDEN_SWORD,
        GOLDEN_AXE,
        GOLDEN_PICKAXE,
        GOLDEN_SHOVEL,
        IRON_SWORD,
        IRON_AXE,
        IRON_PICKAXE,
        IRON_SHOVEL,
        DIAMOND_SWORD,
        DIAMOND_AXE,
        DIAMOND_PICKAXE,
        DIAMOND_SHOVEL,
        TRIDENT,
        NETHERITE_SWORD,
        NETHERITE_AXE,
        NETHERITE_PICKAXE,
        NETHERITE_SHOVEL;

        private final Material type = Material.matchMaterial((String)this.name());
        private final double damage = this.type != null ? Util.getDefaultDamage(this.type) : 0.0;

        public Material getMaterial() {
            return this.type;
        }

        public double getDamage() {
            return this.damage;
        }
    }
}

