/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;

public class TextUtil {
    public static String drawHealthBar(LivingEntity e) {
        int i;
        StringBuilder bar = new StringBuilder();
        bar.append(ChatColor.RED + "\u2764");
        int segments = 10;
        double healthPerBar = e.getMaxHealth() / (double)segments;
        int greenBars = (int)(e.getHealth() / healthPerBar);
        int redBars = segments - greenBars;
        bar.append(ChatColor.GREEN);
        for (i = 0; i < greenBars; ++i) {
            bar.append("|");
        }
        bar.append(ChatColor.RED);
        for (i = 0; i < redBars; ++i) {
            bar.append("|");
        }
        bar.append(ChatColor.GREEN + " " + (int)e.getHealth() + ChatColor.WHITE + "/" + ChatColor.GREEN + (int)e.getMaxHealth());
        return bar.toString();
    }

    public static String drawManaBar(Hero p) {
        int i;
        StringBuilder bar = new StringBuilder();
        bar.append(ChatColor.BLUE + "\u2738");
        int segments = 10;
        double manaPerBar = p.getMaxMana() / segments;
        int blueBars = (int)((double)p.getMana() / manaPerBar);
        int redBars = segments - blueBars;
        bar.append(ChatColor.BLUE);
        for (i = 0; i < blueBars; ++i) {
            bar.append("|");
        }
        bar.append(ChatColor.RED);
        for (i = 0; i < redBars; ++i) {
            bar.append("|");
        }
        bar.append(ChatColor.BLUE + " " + p.getMana() + ChatColor.WHITE + "/" + ChatColor.BLUE + p.getMaxMana());
        return bar.toString();
    }

    public static ChatColor getHealthColour(LivingEntity e) {
        double healthPercent = e.getHealth() / e.getMaxHealth();
        ChatColor colour = ChatColor.WHITE;
        if (healthPercent >= 0.85) {
            colour = ChatColor.DARK_GREEN;
        } else if (healthPercent >= 0.6) {
            colour = ChatColor.GREEN;
        } else if (healthPercent >= 0.35) {
            colour = ChatColor.YELLOW;
        } else if (healthPercent >= 0.2) {
            colour = ChatColor.GOLD;
        } else if (healthPercent >= 0.1) {
            colour = ChatColor.RED;
        } else if (healthPercent >= 0.0) {
            colour = ChatColor.DARK_RED;
        }
        return colour;
    }

    public static String drawCastBar(ActiveSkill as, long startTime, long finTime) {
        int i;
        StringBuilder bar = new StringBuilder();
        int segments = 10;
        long totalTime = finTime - startTime;
        long currentTime = finTime - System.currentTimeMillis();
        double timePerBar = totalTime / (long)segments;
        int aquaBars = (int)((double)currentTime / timePerBar);
        int greyBars = segments - aquaBars;
        bar.append(ChatColor.DARK_AQUA);
        for (i = 0; i < aquaBars; ++i) {
            bar.append("|");
        }
        bar.append(ChatColor.DARK_GRAY);
        for (i = 0; i < greyBars; ++i) {
            bar.append("|");
        }
        return bar.toString();
    }

    public static boolean compareString(String toCompare, String[] possible) {
        for (String s : Arrays.asList(possible)) {
            if (!s.equalsIgnoreCase(toCompare)) continue;
            return true;
        }
        return false;
    }

    public static String formatStackTrace(Throwable e) {
        StringBuilder format = new StringBuilder();
        if (e != null) {
            for (StackTraceElement trace : e.getStackTrace()) {
                format.append(trace.toString()).append("\n");
            }
        }
        return format.toString();
    }
}

