/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.Heroes;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import to.hc.common.core.util.LazyLoad;

public class RegionUtil {
    private static Heroes plugin = Heroes.getInstance();
    private static LazyLoad<WorldGuard> lazyWorldGuard = new LazyLoadWorldguard();
    private static LazyLoad<WorldGuardPlugin> lazyWorldGuardPlugin = new LazyLoadWorldGuardPlugin();

    public static boolean IsNoPvPRegion(LivingEntity player) {
        return RegionUtil.IsNoPvPRegion(player.getLocation());
    }

    public static boolean IsNoPvPRegion(Location location) {
        WorldGuard worldGuard;
        RegionContainer container;
        RegionQuery query;
        ApplicableRegionSet set;
        if (lazyWorldGuard.get() != null && (set = (query = (container = (worldGuard = lazyWorldGuard.get()).getPlatform().getRegionContainer()).createQuery()).getApplicableRegions(BukkitAdapter.adapt((Location)location))) != null && !set.getRegions().isEmpty()) {
            return set.queryState(null, new StateFlag[]{Flags.PVP}) == StateFlag.State.DENY;
        }
        return false;
    }

    public static boolean IsAbleToBuildInRegion(Player player, Location location) {
        if (lazyWorldGuard.get() != null && lazyWorldGuardPlugin != null) {
            WorldGuard worldGuard = lazyWorldGuard.get();
            WorldGuardPlugin wgp = lazyWorldGuardPlugin.get();
            LocalPlayer wgPlayer = wgp.wrapPlayer(player);
            RegionContainer container = worldGuard.getPlatform().getRegionContainer();
            RegionQuery query = container.createQuery();
            return query.testState(BukkitAdapter.adapt((Location)location), wgPlayer, new StateFlag[]{Flags.BUILD});
        }
        return true;
    }

    private static class LazyLoadWorldguard
    extends LazyLoad<WorldGuard> {
        private LazyLoadWorldguard() {
        }

        @Override
        protected WorldGuard load() {
            if (Bukkit.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
                return WorldGuard.getInstance();
            }
            return null;
        }
    }

    private static class LazyLoadWorldGuardPlugin
    extends LazyLoad<WorldGuardPlugin> {
        private LazyLoadWorldGuardPlugin() {
        }

        @Override
        protected WorldGuardPlugin load() {
            if (Bukkit.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
                return WorldGuardPlugin.inst();
            }
            return null;
        }
    }
}

