/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.google.common.collect.Lists;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.feature.scoreboard.config.ScoreboardHeroInfoConfig;
import com.herocraftonline.heroes.feature.scoreboard.config.ScoreboardPartyConfig;
import com.herocraftonline.heroes.items.ComplexItemMatcher;
import com.herocraftonline.heroes.items.WeaponConfig;
import com.herocraftonline.heroes.listeners.DurabilityConfig;
import com.herocraftonline.heroes.ui.scoreboard.HeroInfoComponent;
import com.herocraftonline.heroes.ui.scoreboard.PartyComponent;
import com.herocraftonline.heroes.util.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class Properties {
    public static final List<String> MC_VERSIONS = Lists.newArrayList((Object[])new String[]{"1.13", "1.13.1", "1.13.2", "1.14", "1.14.1", "1.14.2", "1.14.3", "1.14.4", "1.15", "1.15.1", "1.15.2", "1.16", "1.16.1", "1.16.2", "1.16.3", "1.16.4", "1.16.5", "1.17", "1.17.1", "1.18", "1.18.1", "1.18.2"});
    public static final String DETECTED_MC_VERSION;
    public static final int SUBVERSION;
    public static final int SUBVERSION_PATCH_NUMBER;
    public static ServerType serverType;
    public boolean expCalcAlt;
    public double power;
    public static int maxExp;
    public static int maxLevel;
    public static boolean padMaxLevel;
    public static int[] levels;
    public double expLoss;
    public double pvpExpLossMultiplier = 0.0;
    public boolean levelsViaExpLoss = false;
    public boolean masteryLoss = false;
    public int maxPartySize = 6;
    public double partyBonus = 0.0;
    public double playerKillingExp = 0.0;
    public boolean noSpawnCamp = false;
    public double spawnCampExpMult;
    public boolean resetOnDeath;
    public int pvpLevelRange = 50;
    public int minPvpLevel = 1;
    public boolean orbExp;
    public int pvpMaxExpRange = 0;
    public int pvpExpRange = 0;
    public boolean mobHealthDistanceModified = false;
    public double mobHealthModifier = 2.0;
    public boolean mobHealthDistanceModifiedUseMax = false;
    public double mobHealthDistanceModifiedMax = 10000.0;
    public boolean mobExpDistanceModified = false;
    public double mobExpModifier = 2.0;
    public boolean mobExpDistanceModifiedUseMax = false;
    public int mobExpDistanceModifiedMax = 10000;
    public boolean mobDamageDistanceModified = false;
    public double mobDamageModifier = 2.0;
    public boolean mobDamageDistanceModifiedUseMax = false;
    public double mobDamageDistanceModifiedMax = 10000.0;
    public boolean onLevelUpRestoreHealth = true;
    public boolean onLevelUpRestoreShield = true;
    public boolean onLevelUpRestoreMana = true;
    public boolean onLevelUpRestoreStamina = true;
    public boolean showLevelUpEffect = true;
    public boolean loadFromLegacyConfiguration = true;
    public static double[] partyMults;
    public double swapCost;
    public double oldClassSwapCost;
    public double oldClassSwapCostPerLevel;
    public double profSwapCost;
    public double raceSwapCost;
    public double oldProfSwapCost;
    public double oldProfSwapCostPerLevel;
    public double oldRaceSwapCost;
    public double oldRaceSwapCostPerLevel;
    public boolean firstSwitchFree;
    public boolean firstSwitchFreeRace;
    public boolean swapMasterFree;
    public boolean swapWithMasteriesHasFullCost;
    public int numberOfMasteriesForFullCost;
    public boolean prefixClassName;
    public boolean resetExpOnClassChange = true;
    public boolean resetMasteryOnClassChange = false;
    public boolean resetProfMasteryOnClassChange = false;
    public boolean resetProfOnPrimaryChange = false;
    public boolean resetRaceOnPrimaryChange = false;
    public boolean lockPathTillMaster = false;
    public boolean lockAtHighestTier = false;
    public double selfHeal = 1.0;
    public static long classCooldown;
    public static long profCooldown;
    public static long raceCooldown;
    public static String[] classIdMap;
    public int allocationPointsPerLevel;
    public double attributeAllocationCostPerLevel;
    public double attackDamagePerStrength;
    public double healthPerConstitution;
    public double shieldPerConstitution;
    public double magicResistPerConstitution;
    public int shieldRegenerationPerEndurance;
    public int staminaRegenerationPerEndurance;
    public boolean enableCarryWeightPerEndurance;
    public double carryWeightPerEndurance;
    public int staminaPerEndurance;
    public double projectileDamagePerDexterity;
    public double speedIncreasePerDexterity;
    public int manaPerIntellect;
    public int manaRegenerationPerWisdom;
    public double attributeResetCost;
    public boolean checkEquipmentWeight;
    public Map<Material, Double> equipmentWeightMap = new EnumMap<Material, Double>(Material.class);
    public boolean oneHealthBar;
    public double healthPerBar = 20.0;
    public boolean displayEntityHealth;
    private Heroes plugin;
    public boolean debug;
    public String storageType;
    public boolean economy;
    public int blockTrackingDuration;
    public int maxTrackedBlocks;
    public int globalCooldown = 0;
    public double enchantXPMultiplier;
    public boolean slowCasting = true;
    public boolean noSprintWhileCasting = true;
    public boolean noSprintWhileSlowedDefault = true;
    public static int combatTime;
    public static boolean silencePassiveSkills;
    public static boolean silenceNPCSkills;
    public static boolean enableRecipes;
    public String combatEnterMessage;
    public String combatExitMessage;
    public boolean showNotTrainedUseMessage;
    public boolean notTrainedMessageIncludeRequiredClassLevels;
    public boolean defaultVerboseExp = true;
    public boolean defaultVerboseMana = true;
    public boolean defaultVerboseStamina = false;
    public boolean defaultVerboseSkills = true;
    public boolean bedHeal;
    public int healInterval;
    public int healPercent;
    public int shieldRegenInterval;
    public int shieldDelayAfterHit;
    public int manaRegenInterval;
    public double manaRegenMultiplierOutOfCombat;
    public int staminaRegenInterval;
    public int staminaSwingWeaponCost;
    public int staminaShootBowCost;
    public double staminaPerDamageTakenCost;
    public int staminaManaRegenTickCost;
    public double staminaPerManaPointRegenCost;
    public int staminaSprintingCost;
    public boolean staminaStopRegenOnSwingWeapon;
    public boolean staminaStopRegenOnShootBow;
    public boolean staminaStopRegenOnDamageTaken;
    public boolean staminaStopRegenWhileSprinting;
    public long staminaStopRegenOnSwingWeaponDuration;
    public long staminaStopRegenOnShootBowDuration;
    public long staminaStopRegenOnDamageTakenDuration;
    public long staminaStopRegenWhileSprintingDuration;
    public boolean foodEnabled;
    public int foodHealthTimeMult;
    public double foodHealPercent;
    public boolean foodConsumableInCombat;
    public int hatsLevel;
    public boolean allowHats;
    public double expBonus;
    public long expiration;
    public String bonusMessage;
    public Map<EntityType, Double> creatureKillingExp = new EnumMap<EntityType, Double>(EntityType.class);
    public Map<Material, Double> miningExp = new EnumMap<Material, Double>(Material.class);
    public Map<Material, Double> smeltingExp = new EnumMap<Material, Double>(Material.class);
    public Map<Material, Double> farmingExp = new EnumMap<Material, Double>(Material.class);
    public Map<Material, Double> loggingExp = new EnumMap<Material, Double>(Material.class);
    public Map<Material, Double> craftingExp = new EnumMap<Material, Double>(Material.class);
    public Map<Material, Double> buildingExp = new EnumMap<Material, Double>(Material.class);
    public Map<String, String> skillInfo = new HashMap<String, String>();
    public double fishingExp = 0.0;
    public double shearExp = 0.0;
    public double tameExp = 0.0;
    public double breedingExp = 0.0;
    public double brewingPotionExp = 0.0;
    public double brewingSplashPotionExp = 0.0;
    public double brewingLingeringPotionExp = 0.0;
    public double potHealthPerTier;
    public String standardEffectBleedingApplyText;
    public String standardEffectBleedingRemoveText;
    public int standardEffectBleedingMaxStacks;
    public double standardEffectBleedingDamagePerStack;
    public long standardEffectBleedingPeriod;
    public int standardEffectBleedingParticleCount;
    public String standardEffectDeepWoundApplyText;
    public String standardEffectDeepWoundRemoveText;
    public double standardEffectDeepWoundPercentMaxHealthReduction;
    public String standardEffectSlownessApplyText;
    public String standardEffectSlownessRemoveText;
    public String standardEffectSwiftnessApplyText;
    public String standardEffectSwiftnessRemoveText;
    public boolean mitigationEnabled;
    public double maximumDamageReduction;
    public double perArmorDamageReduction;
    public List<String> mitigationDamageCauses = new ArrayList<String>();
    public int armorDurabilityDamageReduction = 1;
    public boolean skillsCauseDamageToArmor;
    public boolean skillsCauseDamageToWeapons;
    public boolean customDurabilityEnabled;
    public boolean showCustomDurabilityText;
    public boolean syncWithMinecraftDurability;
    public int defaultCustomMaxDurability;
    public List<DurabilityConfig> durabilityMatchConfigs = new ArrayList<DurabilityConfig>();
    public int noDamageTicks;
    public List<String> noCombatMaterials;
    public boolean considerWeaponSwingCooldownForDamage = true;
    public boolean useToolsInPermittedWeapons;
    public boolean protectUserAndAlliesForFireworkDuration = true;
    public String fireworkImmunityExpireMessage;
    public boolean respawnFeaturesEnabled;
    public double respawnHealthPercent;
    public double respawnShieldPercent;
    public double respawnManaPercent;
    public double respawnStaminaPercent;
    public double respawnHealthRegenSeconds;
    public boolean itemRollEnabled;
    public boolean itemRollIncludeVictimName;
    public int itemRollExpireSeconds;
    public double[] itemRollNearbyEntitiesRadius;
    public boolean modifySplashPotionsEffectedEntitiesEnabled = true;
    public boolean modifySplashPotionsProtectThrower = true;
    public boolean modifySplashPotionsProtectAllies = true;
    public boolean modifySplashPotionsAllyOnlyPositiveEffects = false;
    public boolean scoreboardEnabled;
    public String scoreboardTitle;
    public boolean useExperimentalFeatures = false;
    public float defaultKnockback = 0.5f;
    private List<WeaponConfig> weaponConfig = new ArrayList<WeaponConfig>();

    public Properties() {
        Heroes.properties = this;
        serverType = Bukkit.getServer().getVersion().split("-")[1].toLowerCase().equals("spigot") ? ServerType.SPIGOT : ServerType.BUKKIT;
        Heroes.log(Level.INFO, "Minecraft version: " + DETECTED_MC_VERSION);
        boolean match = false;
        for (String MC_VERSION : MC_VERSIONS) {
            if (!DETECTED_MC_VERSION.equals(MC_VERSION)) continue;
            match = true;
            break;
        }
        if (!match) {
            Heroes.log(Level.WARNING, "####################################################################################################");
            Heroes.log(Level.WARNING, "                Heroes has not been tested with this version of Minecraft!                          ");
            Heroes.log(Level.WARNING, "                      THIS IS NOT AN ERROR - Use at your own risk!                                  ");
            Heroes.log(Level.WARNING, "####################################################################################################");
        }
    }

    public void load(Heroes plugin) {
        this.plugin = plugin;
        FileConfiguration config = plugin.getConfig();
        config.options().copyDefaults(true);
        plugin.saveConfig();
        this.loadAttributesConfig(config.getConfigurationSection("attributes"));
        this.loadEquipmentWeightConfig(config.getConfigurationSection("equipment-weight"));
        this.loadLevelConfig(config.getConfigurationSection("leveling"));
        this.loadClassConfig(config.getConfigurationSection("classes"));
        this.loadProperties(config.getConfigurationSection("properties"));
        this.loadVerbose(config.getConfigurationSection("verbose"));
        this.loadShieldConfig(config.getConfigurationSection("shield"));
        this.loadManaConfig(config.getConfigurationSection("mana"));
        this.loadStaminaConfig(config.getConfigurationSection("stamina"));
        this.loadFoodConfig(config.getConfigurationSection("food"));
        this.loadBedConfig(config.getConfigurationSection("bed"));
        this.loadHatsConfig(config.getConfigurationSection("hats"));
        this.loadBonusConfig(config.getConfigurationSection("bonus"));
        this.loadHealthBarConfig(config.getConfigurationSection("healthbar"));
        this.loadMitigation(config.getConfigurationSection("global-mitigation"));
        this.loadDurability(config, config.getConfigurationSection("durability"));
        this.loadFeatures(config.getConfigurationSection("features"));
        this.loadExperimentalFeatures(config.getConfigurationSection("experimental-features"));
        ConfigurationSection oldDatabase = config.getConfigurationSection("database");
        if (oldDatabase != null) {
            Heroes.log(Level.WARNING, "You are using legacy database config! Your current configuration will be moved to a separate file called database.yml! This will be done automagically.");
            File databaseFile = new File(plugin.getDataFolder(), "database.yml");
            YamlConfiguration database = new YamlConfiguration();
            ConfigurationSection section = database.createSection("database");
            section.set("type", oldDatabase.get("type"));
            section.set("db", oldDatabase.get("db"));
            section.set("poolsize", oldDatabase.get("poolsize"));
            section.set("url", oldDatabase.get("url"));
            section.set("port", oldDatabase.get("port"));
            section.set("username", oldDatabase.get("username"));
            section.set("password", oldDatabase.get("password"));
            try {
                database.save(databaseFile);
                config.set("database", null);
                plugin.saveConfig();
            }
            catch (IOException e) {
                Heroes.log(Level.SEVERE, "Something went wrong converting legacy database!");
            }
        }
    }

    private void loadMitigation(ConfigurationSection mitigation) {
        if (mitigation == null) {
            this.mitigationEnabled = false;
            this.maximumDamageReduction = 0.8;
            this.perArmorDamageReduction = 0.04;
            this.mitigationDamageCauses = new ArrayList<String>();
            return;
        }
        this.mitigationEnabled = mitigation.getBoolean("enabled", false);
        this.maximumDamageReduction = mitigation.getDouble("maximum-damage-reduction", 0.8);
        this.perArmorDamageReduction = mitigation.getDouble("per-armor-damage-reduction-percent", 0.04);
        this.mitigationDamageCauses = mitigation.getStringList("mitigation-damage-causes");
    }

    private void loadDurability(FileConfiguration config, ConfigurationSection durability) {
        if (durability == null) {
            return;
        }
        this.armorDurabilityDamageReduction = Util.toIntNonNull(durability.getInt("armor-durability-damage-reduction", 1), "armor-durability-damage-reduction");
        this.skillsCauseDamageToArmor = durability.getBoolean("armor-is-damaged-by-skills", true);
        this.skillsCauseDamageToWeapons = durability.getBoolean("weapons-are-damaged-by-skill-usage", true);
        ConfigurationSection customDurability = durability.getConfigurationSection("custom-system");
        if (customDurability == null) {
            return;
        }
        this.customDurabilityEnabled = customDurability.getBoolean("enabled", false);
        this.showCustomDurabilityText = customDurability.getBoolean("show-custom-durability-text", true);
        this.syncWithMinecraftDurability = customDurability.getBoolean("sync-with-minecraft-durability", true);
        this.defaultCustomMaxDurability = Util.toIntNonNull(customDurability.getInt("default-maximum-durability", 350), "default-maximum-durability");
        try {
            customDurability.getMapList("overrides").forEach(overrideItem -> this.durabilityMatchConfigs.add(new DurabilityConfig(new ComplexItemMatcher(overrideItem.get("name-match").toString(), overrideItem.get("type-match").toString()), Integer.parseInt("0" + overrideItem.get("max-durability").toString()))));
        }
        catch (Exception ex) {
            this.customDurabilityEnabled = false;
            Heroes.log(Level.SEVERE, ex.toString());
        }
    }

    private void loadFeatures(ConfigurationSection features) {
        if (features == null) {
            this.noDamageTicks = 10;
            this.noCombatMaterials = Arrays.asList(Material.LAVA_BUCKET.name(), Material.FLINT_AND_STEEL.name(), Material.MILK_BUCKET.name());
            this.useToolsInPermittedWeapons = false;
            this.itemRollEnabled = true;
            this.itemRollIncludeVictimName = false;
            this.itemRollExpireSeconds = 30;
            this.itemRollNearbyEntitiesRadius = new double[3];
            this.itemRollNearbyEntitiesRadius[0] = 10.0;
            this.itemRollNearbyEntitiesRadius[1] = 10.0;
            this.itemRollNearbyEntitiesRadius[2] = 10.0;
            this.scoreboardEnabled = true;
            this.scoreboardTitle = ChatColor.GREEN + ChatColor.BOLD + "\u26a0 Character \u26a0";
            HeroInfoComponent.SELF.config = new ScoreboardHeroInfoConfig();
            PartyComponent.SELF.config = new ScoreboardPartyConfig();
            return;
        }
        ConfigurationSection itemRollRadius = features.getConfigurationSection("item-roll.radius");
        this.noDamageTicks = features.getInt("no-damage-ticks", 10);
        this.noCombatMaterials = features.getStringList("no-combat-materials");
        this.considerWeaponSwingCooldownForDamage = features.getBoolean("consider-weapon-swing-cooldown-for-damage", true);
        this.useToolsInPermittedWeapons = features.getBoolean("use-tools-in-permitted-weapons", false);
        this.protectUserAndAlliesForFireworkDuration = features.getBoolean("fireworks.protect-allies-for-firework-duration", true);
        this.fireworkImmunityExpireMessage = features.getString("fireworks.immunity-effect-expire-message");
        this.respawnFeaturesEnabled = features.getBoolean("respawn-features-enabled", false);
        this.respawnHealthPercent = features.getDouble("respawn-health-percent", 50.0);
        this.respawnShieldPercent = features.getDouble("respawn-shield-percent", 50.0);
        this.respawnManaPercent = features.getDouble("respawn-mana-percent", 50.0);
        this.respawnStaminaPercent = features.getDouble("respawn-stamina-percent", 50.0);
        this.respawnHealthRegenSeconds = features.getDouble("respawn-health-regen-seconds", 30.0);
        this.itemRollEnabled = features.getBoolean("item-roll.enabled", true);
        this.itemRollIncludeVictimName = features.getBoolean("item-roll.include-victim-name", false);
        this.itemRollExpireSeconds = features.getInt("item-roll.expire-seconds", 30);
        this.itemRollNearbyEntitiesRadius = new double[3];
        this.itemRollNearbyEntitiesRadius[0] = itemRollRadius.getDouble("x", 10.0);
        this.itemRollNearbyEntitiesRadius[1] = itemRollRadius.getDouble("y", 10.0);
        this.itemRollNearbyEntitiesRadius[2] = itemRollRadius.getDouble("z", 10.0);
        this.modifySplashPotionsEffectedEntitiesEnabled = features.getBoolean("modify-splash-potions.enabled", true);
        this.modifySplashPotionsProtectThrower = features.getBoolean("modify-splash-potions.protect-thrower", true);
        this.modifySplashPotionsProtectAllies = features.getBoolean("modify-splash-potions.protect-allies", true);
        this.modifySplashPotionsAllyOnlyPositiveEffects = features.getBoolean("modify-splash-potions.ally-only-positive-effects", false);
        this.scoreboardEnabled = features.getBoolean("scoreboard.enabled", true);
        this.scoreboardTitle = features.getString("scoreboard.title", ChatColor.GREEN + ChatColor.BOLD + "\u26a0 Character \u26a0");
        ConfigurationSection scoreboardComponentInfo = features.getConfigurationSection("scoreboard.component.info");
        HeroInfoComponent.SELF.config = scoreboardComponentInfo != null ? new ScoreboardHeroInfoConfig(scoreboardComponentInfo) : new ScoreboardHeroInfoConfig();
        ConfigurationSection scoreboardComponentParty = features.getConfigurationSection("scoreboard.component.party");
        PartyComponent.SELF.config = scoreboardComponentParty != null ? new ScoreboardPartyConfig(scoreboardComponentParty) : new ScoreboardPartyConfig();
    }

    private void loadExperimentalFeatures(ConfigurationSection features) {
        if (features != null && features.getBoolean("enabled")) {
            try {
                this.useExperimentalFeatures = true;
                ConfigurationSection weapons = features.getConfigurationSection("custom-weapons");
                if (weapons != null) {
                    this.defaultKnockback = (float)weapons.getDouble("default-knockback", 0.5);
                    boolean considerLore = weapons.getBoolean("consider-name-and-lore", false);
                    weapons.getMapList("overrides").forEach(overrideItem -> {
                        String knockback = overrideItem.get("knockback-level").toString();
                        String penetration = overrideItem.get("penetration-percent").toString();
                        String reach = overrideItem.get("reach-distance").toString();
                        this.weaponConfig.add(new WeaponConfig(new ComplexItemMatcher(overrideItem.get("name-match").toString(), overrideItem.get("type-match").toString(), considerLore), Float.parseFloat(knockback != null ? knockback : String.valueOf(Heroes.properties.defaultKnockback)), Float.parseFloat(penetration != null ? penetration : "0") / 100.0f, Float.parseFloat(reach != null ? reach : "3")));
                    });
                }
            }
            catch (Exception e) {
                this.useExperimentalFeatures = false;
                Heroes.log(Level.SEVERE, e.toString());
            }
        }
    }

    public float getCustomKnockback(ItemStack item) {
        WeaponConfig config;
        float knockback = this.defaultKnockback;
        if (this.useExperimentalFeatures && (config = this.getWeaponConfigMatch(item)) != null) {
            knockback = config.getKnockback();
        }
        return knockback;
    }

    @Nullable
    public WeaponConfig getWeaponConfigMatch(ItemStack item) {
        WeaponConfig config = null;
        if (this.useExperimentalFeatures) {
            for (WeaponConfig entry : this.weaponConfig) {
                if (!entry.getMatcher().isAMatch(item)) continue;
                config = entry;
                break;
            }
        }
        return config;
    }

    private void loadHealthBarConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.oneHealthBar = section.getBoolean("limit-one-bar");
        this.healthPerBar = section.getDouble("health-per-bar");
        if (this.healthPerBar < 20.0) {
            Heroes.log(Level.SEVERE, "For safety reasons, the minimum health that can be displayed on a health bar is 20 unless using limit-one-bar!");
            this.healthPerBar = 20.0;
        }
        this.displayEntityHealth = section.getBoolean("display-entity-health", false);
    }

    private void loadBonusConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.expBonus = section.getDouble("exp", 1.0);
        this.expiration = section.getLong("expiration", 0L);
        this.bonusMessage = section.getString("message");
    }

    private void loadBedConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.bedHeal = section.getBoolean("enabled", true);
        this.healInterval = Util.toIntNonNull(section.get("interval", (Object)30), "interval");
        this.healPercent = Util.toIntNonNull(section.get("percent", (Object)5), "percent");
    }

    private void loadHatsConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.hatsLevel = Util.toIntNonNull(section.get("level", (Object)1), "level");
        this.allowHats = section.getBoolean("enabled", false);
    }

    private void loadLevelConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.power = Util.toDoubleNonNull(section.get("exp-curve", (Object)1.0), "exp-curve");
        maxExp = Util.toIntNonNull(section.get("max-exp", (Object)100000), "max-exp");
        maxLevel = Util.toIntNonNull(section.get("max-level", (Object)20), "max-level");
        padMaxLevel = section.getBoolean("pad-max-level", true);
        this.maxPartySize = Util.toIntNonNull(section.get("max-party-size"), "max-party-size");
        this.partyBonus = Util.toDoubleNonNull(section.get("party-exp-bonus", (Object)0.2), "party-exp-bonus");
        this.expLoss = Util.toDoubleNonNull(section.get("exp-loss", (Object)0.05), "expLoss");
        this.pvpExpLossMultiplier = Util.toDoubleNonNull(section.get("pvp-exp-loss", (Object)1.0), "pvp-exp-loss");
        this.levelsViaExpLoss = section.getBoolean("level-loss", false);
        this.masteryLoss = section.getBoolean("mastery-loss", false);
        this.noSpawnCamp = section.getBoolean("spawner-checks", false);
        this.spawnCampExpMult = Util.toDoubleNonNull(section.get("spawner-exp-mult", (Object)0.5), "spawner-exp-mult");
        this.resetOnDeath = section.getBoolean("reset-on-death", false);
        this.pvpLevelRange = Util.toIntNonNull(section.get("pvp-range", (Object)50), "pvp-range");
        this.minPvpLevel = Util.toIntNonNull(section.get("min-pvp-level", (Object)1), "min-pvp-level");
        this.pvpExpRange = Util.toIntNonNull(section.get("pvp-exp-range", (Object)10), "pvp-exp-range");
        this.pvpMaxExpRange = Util.toIntNonNull(section.get("pvp-max-exp-range", (Object)40), "pvp-max-exp-range");
        this.mobHealthDistanceModified = section.getBoolean("mob-health-distance-modified", false);
        this.mobHealthModifier = Util.toDoubleNonNull(section.getDouble("mob-health-modifier", 2.0), "mob-health-modifier");
        this.mobHealthDistanceModifiedUseMax = section.getBoolean("mob-health-modified-use-max", false);
        this.mobHealthDistanceModifiedMax = Util.toDoubleNonNull(section.getDouble("mob-health-modified-max", 10000.0), "mob-health-modified-max");
        this.mobExpDistanceModified = section.getBoolean("mob-experience-distance-modified", false);
        this.mobExpModifier = Util.toDoubleNonNull(section.getDouble("mob-exp-modifier", 2.0), "mob-exp-modifier");
        this.mobExpDistanceModifiedUseMax = section.getBoolean("mob-exp-modified-use-max", false);
        this.mobExpDistanceModifiedMax = Util.toIntNonNull(section.get("mob-exp-modified-max", (Object)10000), "mob-exp-modified-max");
        this.mobDamageDistanceModified = section.getBoolean("mob-damage-distance-modified", false);
        this.mobDamageModifier = Util.toDoubleNonNull(section.getDouble("mob-damage-modifier", 2.0), "mob-damage-modifier");
        this.mobDamageDistanceModifiedUseMax = section.getBoolean("mob-damage-modified-use-max", false);
        this.mobDamageDistanceModifiedMax = Util.toDoubleNonNull(section.getDouble("mob-damage-modified-max", 10000.0), "mob-damage-modified-max");
        this.onLevelUpRestoreHealth = section.getBoolean("on-level-up-restore-health", true);
        this.onLevelUpRestoreShield = section.getBoolean("on-level-up-restore-shield", true);
        this.onLevelUpRestoreMana = section.getBoolean("on-level-up-restore-mana", true);
        this.onLevelUpRestoreStamina = section.getBoolean("on-level-up-restore-stamina", true);
        this.showLevelUpEffect = section.getBoolean("show-level-up-effect", true);
        this.pvpMaxExpRange -= this.pvpExpRange;
        Heroes.log(Level.INFO, "Minimum PvP Level is set to: " + this.minPvpLevel);
        this.expCalcAlt = section.getBoolean("exp-calc-alt", false);
        this.calcExp();
        if (section.getBoolean("dump-exp-file", false)) {
            this.dumpExpLevels();
        }
        this.calcPartyMultipliers();
    }

    private void dumpExpLevels() {
        File levelFile = new File(this.plugin.getDataFolder(), "levels.txt");
        if (levelFile.exists()) {
            levelFile.delete();
        }
        try {
            levelFile.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (BufferedWriter bos = new BufferedWriter(new FileWriter(levelFile));){
            for (int i = 0; i < maxLevel; ++i) {
                bos.append(i + " - " + Properties.getTotalExp(i + 1) + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadAttributesConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.allocationPointsPerLevel = Util.toIntNonNull(section.get("allocation-points-per-level", (Object)3), "allocation-points-per-level");
        this.attributeAllocationCostPerLevel = Util.toDoubleNonNull(section.get("attribute-allocation-cost-per-level", (Object)0.2), "attribute-allocation-cost-per-level");
        this.attackDamagePerStrength = Util.toDoubleNonNull(section.get("attack-damage-per-strength", (Object)1.7), "attack-damage-per-strength");
        this.healthPerConstitution = Util.toDoubleNonNull(section.get("health-per-constitution", (Object)37.0), "health-per-constitution");
        this.shieldPerConstitution = Util.toDoubleNonNull(section.get("shield-per-constitution", (Object)0.0), "shield-per-constitution");
        this.magicResistPerConstitution = Util.toDoubleNonNull(section.get("magic-resist-per-constitution", (Object)0.03), "magic-resist-per-constitution");
        this.shieldRegenerationPerEndurance = Util.toIntNonNull(section.get("shield-regeneration-per-endurance", (Object)0), "shield-regeneration-per-endurance");
        this.staminaRegenerationPerEndurance = Util.toIntNonNull(section.get("stamina-regeneration-per-endurance", (Object)1), "stamina-regeneration-per-endurance");
        this.enableCarryWeightPerEndurance = section.getBoolean("enable-carry-weight-per-endurance", true);
        this.carryWeightPerEndurance = Util.toDoubleNonNull(section.get("carry-weight-per-endurance", (Object)0.0), "carry-weight-per-endurance");
        this.staminaPerEndurance = Util.toIntNonNull(section.get("stamina-per-endurance", (Object)1), "stamina-per-endurance");
        this.projectileDamagePerDexterity = Util.toDoubleNonNull(section.get("projectile-damage-per-dexterity", (Object)4.0), "projectile-damage-per-dexterity");
        this.speedIncreasePerDexterity = Util.toDoubleNonNull(section.get("speed-increase-per-dexterity", (Object)0.001), "speed-increase-per-dexterity");
        this.manaPerIntellect = Util.toIntNonNull(section.get("mana-per-intellect", (Object)5), "mana-per-intellect");
        this.manaRegenerationPerWisdom = Util.toIntNonNull(section.get("mana-regeneration-per-wisdom", (Object)1), "mana-regeneration-per-wisdom");
        this.attributeResetCost = Util.toDoubleNonNull(section.get("attribute-reset-cost", (Object)0), "attribute-reset-cost");
    }

    private void loadEquipmentWeightConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        HashMap<Material, Double> equipmentWeightMap = new HashMap<Material, Double>();
        Set keys = section.getKeys(false);
        for (String item : keys) {
            double weight = section.getDouble(item, 0.0);
            Material type = Material.matchMaterial((String)item);
            if (type != null) {
                equipmentWeightMap.put(type, weight);
                continue;
            }
            Heroes.log(Level.WARNING, "Invalid material type (" + item + ") found in config.yml.");
        }
        if (keys.size() == 0) {
            Heroes.log(Level.SEVERE, "There are no equipment weight values stored in the config.yml. Equipment Weight will not function properly!");
        }
        this.equipmentWeightMap = equipmentWeightMap;
    }

    private void loadClassConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.prefixClassName = section.getBoolean("use-prefix", false);
        this.resetExpOnClassChange = section.getBoolean("reset-exp-on-change", true);
        this.resetMasteryOnClassChange = section.getBoolean("reset-master-on-change", false);
        this.resetProfMasteryOnClassChange = section.getBoolean("reset-prof-master-on-change", false);
        this.resetProfOnPrimaryChange = section.getBoolean("reset-prof-on-pri-change", false);
        this.lockPathTillMaster = section.getBoolean("lock-till-master", false);
        this.lockAtHighestTier = section.getBoolean("lock-at-max-level", false);
        this.swapMasterFree = section.getBoolean("master-swap-free", true);
        this.firstSwitchFree = section.getBoolean("first-swap-free", true);
        this.firstSwitchFreeRace = section.getBoolean("first-swap-free-race", true);
        this.swapWithMasteriesHasFullCost = section.getBoolean("swap-with-masteries-has-full-cost", false);
        this.numberOfMasteriesForFullCost = section.getInt("number-of-masteries-for-full-cost", 1);
        this.swapCost = Util.toDoubleNonNull(section.get("swap-cost", (Object)0), "swap-cost");
        this.oldClassSwapCost = Util.toDoubleNonNull(section.get("old-swap-cost", (Object)0), "old-swap-cost");
        this.oldClassSwapCostPerLevel = Util.toDoubleNonNull(section.get("old-swap-cost-per-level", (Object)0), "old-swap-cost-per-level");
        this.profSwapCost = Util.toDoubleNonNull(section.get("prof-swap-cost", (Object)0.0), "prof-swap-cost");
        this.oldProfSwapCost = Util.toDoubleNonNull(section.get("old-prof-swap-cost", (Object)0.0), "old-prof-swap-cost");
        this.oldProfSwapCostPerLevel = Util.toDoubleNonNull(section.get("old-prof-swap-cost-per-level", (Object)0.0), "old-prof-swap-cost-per-level");
        this.raceSwapCost = Util.toDoubleNonNull(section.get("race-swap-cost", (Object)0), "race-swap-cost");
        this.oldRaceSwapCost = Util.toDoubleNonNull(section.get("old-race-swap-cost", (Object)0.0), "old-race-swap-cost");
        this.oldRaceSwapCostPerLevel = Util.toDoubleNonNull(section.get("old-race-swap-cost-per-level", (Object)0.0), "old-race-swap-cost-per-level");
        this.selfHeal = Util.toDoubleNonNull(section.get("self-heal"), "self-heal");
        classCooldown = section.getLong("class-change-cooldown", 600000L);
        profCooldown = section.getLong("prof-change-cooldown", 60000L);
        raceCooldown = section.getLong("race-change-cooldown", 600000L);
        List reqs = section.getStringList("ultimate-class-requirement-list");
        classIdMap = reqs.toArray(new String[reqs.size()]);
    }

    private void loadShieldConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.shieldRegenInterval = Util.toIntNonNull(section.get("interval", (Object)2), "interval");
        this.shieldDelayAfterHit = Util.toIntNonNull(section.get("delay", (Object)10), "delay");
    }

    private void loadManaConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.manaRegenInterval = Util.toIntNonNull(section.get("interval", (Object)5), "interval");
        this.manaRegenMultiplierOutOfCombat = section.getDouble("regen-multiplier-out-of-combat", 4.0);
    }

    private void loadStaminaConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.staminaRegenInterval = Util.toIntNonNull(section.get("interval", (Object)1), "interval");
        this.staminaSwingWeaponCost = section.getInt("costs.swing-weapon", 0);
        this.staminaShootBowCost = section.getInt("costs.shoot-bow", 0);
        this.staminaPerDamageTakenCost = section.getDouble("costs.per-damage-taken", 0.0);
        this.staminaManaRegenTickCost = section.getInt("costs.mana-regen-tick", 0);
        this.staminaPerManaPointRegenCost = section.getDouble("costs.per-mana-point-regen", 0.0);
        this.staminaSprintingCost = section.getInt("costs.sprinting", 0);
        this.staminaStopRegenOnSwingWeapon = section.getBoolean("stop-regen.swing-weapon.enabled", false);
        this.staminaStopRegenOnShootBow = section.getBoolean("stop-regen.shoot-bow.enabled", false);
        this.staminaStopRegenOnDamageTaken = section.getBoolean("stop-regen.take-damage.enabled", false);
        this.staminaStopRegenWhileSprinting = section.getBoolean("stop-regen.sprinting.enabled", false);
        this.staminaStopRegenOnSwingWeaponDuration = section.getLong("stop-regen.swing-weapon.duration", 3000L);
        this.staminaStopRegenOnShootBowDuration = section.getLong("stop-regen.shoot-bow.duration", 3000L);
        this.staminaStopRegenOnDamageTakenDuration = section.getLong("stop-regen.take-damage.duration", 3000L);
        this.staminaStopRegenWhileSprintingDuration = section.getLong("stop-regen.sprinting.duration", 3000L);
    }

    private void loadFoodConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.foodEnabled = section.getBoolean("enabled", false);
        this.foodHealthTimeMult = Util.toIntNonNull(section.get("time-multiplier", (Object)5), "time-multiplier") * 1000;
        this.foodHealPercent = Util.toDoubleNonNull(section.get("food-heal-percent", (Object)0.05), "food-heal-percent");
        this.foodConsumableInCombat = section.getBoolean("consumable-in-combat", false);
    }

    private void loadProperties(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.storageType = section.getString("storage-type", "yml");
        this.economy = section.getBoolean("economy", false);
        this.debug = section.getBoolean("debug", false);
        this.globalCooldown = Util.toIntNonNull(section.get("global-cooldown", (Object)1), "global-cooldown");
        this.blockTrackingDuration = Util.toIntNonNull(section.get("block-tracking-duration", (Object)600000), "block-tracking-duration");
        this.maxTrackedBlocks = Util.toIntNonNull(section.get("max-tracked-blocks", (Object)1000), "max-tracked-blocks");
        this.enchantXPMultiplier = Util.toDoubleNonNull(section.get("enchant-exp-mult", (Object)1), "enchant-exp-mult");
        this.slowCasting = section.getBoolean("slow-while-casting", true);
        this.noSprintWhileCasting = section.getBoolean("no-sprint-while-casting", true);
        this.noSprintWhileSlowedDefault = section.getBoolean("no-sprint-while-slowed", true);
        combatTime = Util.toIntNonNull(section.get("combat-time", (Object)10000), "combat-time");
        silencePassiveSkills = section.getBoolean("silence-passive-skill-messages", false);
        silenceNPCSkills = section.getBoolean("silence-npc-messages", true);
        this.checkEquipmentWeight = section.getBoolean("check-equipment-weight", false);
        enableRecipes = section.getBoolean("enable-recipes", true);
        this.combatEnterMessage = section.getString("combat-enter-message", "You have entered combat!");
        this.combatExitMessage = section.getString("combat-exit-message", "You have left combat!");
        this.showNotTrainedUseMessage = section.getBoolean("show-not-trained-use-message", true);
        this.notTrainedMessageIncludeRequiredClassLevels = section.getBoolean("not-trained-message-include-required-class-levels", true);
        this.loadFromLegacyConfiguration = section.getBoolean("load-legacy-player-data", true);
    }

    private void loadVerbose(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.defaultVerboseExp = section.getBoolean("exp", true);
        this.defaultVerboseMana = section.getBoolean("mana", true);
        this.defaultVerboseStamina = section.getBoolean("stamina", false);
        this.defaultVerboseSkills = section.getBoolean("skills", true);
    }

    protected void calcExp() {
        levels = new int[maxLevel + 1];
        if (this.expCalcAlt) {
            double h = Math.log((double)maxExp / (Math.exp(this.power * (double)(maxLevel - 1)) - 1.0)) / this.power;
            double v = -Math.exp(this.power * h);
            for (int i = 0; i < maxLevel + 1; ++i) {
                Properties.levels[i] = (int)Math.round(Math.exp(this.power * ((double)i + h)) + v);
            }
        } else {
            double A = (double)maxExp * Math.pow(maxLevel - 1, -(this.power + 1.0));
            for (int i = 0; i < maxLevel + 1; ++i) {
                Properties.levels[i] = (int)Math.round(A * Math.pow(i, this.power + 1.0));
            }
        }
    }

    protected void calcPartyMultipliers() {
        partyMults = new double[this.maxPartySize];
        for (int i = 0; i < this.maxPartySize; ++i) {
            Properties.partyMults[i] = ((double)this.maxPartySize - 1.0) / ((double)this.maxPartySize * Math.log(this.maxPartySize)) * Math.log(i + 1);
        }
    }

    public static int getTotalExp(int level) {
        if (level >= levels.length) {
            return levels[levels.length - 1];
        }
        if (level < 1) {
            return levels[0];
        }
        return levels[level - 1];
    }

    public static int getExp(int level) {
        if (level <= 1) {
            return 0;
        }
        return Properties.getTotalExp(level) - Properties.getTotalExp(level - 1);
    }

    public static int getLevel(double exp) {
        for (int i = maxLevel - 1; i >= 0; --i) {
            if (!(exp >= (double)levels[i])) continue;
            return i + 1;
        }
        return -1;
    }

    public void saveConfig() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("bonus.message", (Object)this.bonusMessage);
        config.set("bonus.exp", (Object)this.expBonus);
        config.set("bonus.expiration", (Object)this.expiration);
        this.plugin.saveConfig();
    }

    static {
        silencePassiveSkills = false;
        silenceNPCSkills = true;
        enableRecipes = true;
        String[] temp = Bukkit.getServer().getVersion().split("\\(MC: ");
        DETECTED_MC_VERSION = temp[1].trim().substring(0, temp[1].length() - 1);
        String[] versions = DETECTED_MC_VERSION.split("\\.");
        int minor = 0;
        int patch = 0;
        if (versions.length > 1) {
            try {
                minor = Integer.parseInt(versions[1]);
                if (versions.length > 2) {
                    patch = Integer.parseInt(versions[2]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        SUBVERSION = minor;
        SUBVERSION_PATCH_NUMBER = patch;
    }

    public static enum ServerType {
        BUKKIT,
        SPIGOT;

    }
}

