/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;

public class MathUtils {
    private MathUtils() {
    }

    public static List<Location> getCirclePoints(Location location, Plane plane, float range) {
        return MathUtils.getCirclePoints(location, plane, range, 360);
    }

    public static List<Location> getCirclePoints(Location location, Plane plane, float range, int amount) {
        return MathUtils.getCirclePoints0(location, plane, range, amount, 0);
    }

    private static List<Location> getCirclePoints0(Location location, Plane plane, float range, int amount, int startrotation) {
        ArrayList<Location> points = new ArrayList<Location>();
        int j = 360 / amount;
        block4: for (int i = 0; i < 360 / j; ++i) {
            int d = i * j + startrotation;
            double x = (double)range * Math.cos(Math.toRadians(d));
            double y = (double)range * Math.sin(Math.toRadians(d));
            switch (plane) {
                case XZ: {
                    points.add(new Location(location.getWorld(), location.getX() + x, location.getY(), location.getZ() + y));
                    continue block4;
                }
                case YZ: {
                    points.add(new Location(location.getWorld(), location.getX(), location.getY() + y, location.getZ() + x));
                    continue block4;
                }
                default: {
                    points.add(new Location(location.getWorld(), location.getX() + x, location.getY() + y, location.getZ()));
                }
            }
        }
        return points;
    }

    public static List<Location> getLinePoints(Location start, Location end, int amount) {
        ArrayList<Location> points = new ArrayList<Location>();
        double k = start.getX();
        double j = start.getY();
        double n = start.getZ();
        double l = end.getX() - k;
        double h = end.getY() - j;
        double w = end.getZ() - n;
        double f1 = l / (double)amount;
        double f2 = h / (double)amount;
        double f3 = w / (double)amount;
        for (int i = 0; i < amount; ++i) {
            points.add(new Location(start.getWorld(), k + f1 * (double)i, j + f2 * (double)i, n + f3 * (double)i));
        }
        return points;
    }

    public static List<Location> getShapePoints(Location position, Plane plane, float range, int corners, int amount) {
        return MathUtils.getShapePoints(position, plane, range, corners, amount, 0);
    }

    public static List<Location> getShapePoints(Location position, Plane plane, float range, int corners, int amount, int startrotation) {
        ArrayList<Location> points = new ArrayList<Location>();
        List<Location> points2 = MathUtils.getCirclePoints0(position, plane, range, corners, startrotation);
        points.addAll(points2);
        int a = (amount - corners) / corners;
        Location start = null;
        Location last = null;
        for (int i = 0; i < points2.size(); ++i) {
            if (start == null) {
                last = start = points2.get(i);
                continue;
            }
            Location point = points2.get(i);
            points.addAll(MathUtils.getLinePoints(last, point, a));
            last = point;
        }
        if (start != null && last != null) {
            points.addAll(MathUtils.getLinePoints(last, start, a));
        }
        return points;
    }

    public static List<Location> getStarPoints(Location position, Plane plane, float range, int amount) {
        return MathUtils.getStarPoints(position, plane, range, amount, 0);
    }

    public static List<Location> getStarPoints(Location position, Plane plane, float range, int amount, int startrotation) {
        List<Location> points = MathUtils.getCirclePoints0(position, plane, range, 5, startrotation);
        int a = (amount - 5) / 5;
        Location p1 = points.get(0);
        Location p2 = points.get(1);
        Location p3 = points.get(2);
        Location p4 = points.get(3);
        Location p5 = points.get(4);
        points.addAll(MathUtils.getLinePoints(p1, p3, a));
        points.addAll(MathUtils.getLinePoints(p1, p4, a));
        points.addAll(MathUtils.getLinePoints(p2, p4, a));
        points.addAll(MathUtils.getLinePoints(p2, p5, a));
        points.addAll(MathUtils.getLinePoints(p3, p5, a));
        return points;
    }

    public static List<Location> getOctahedronPoints(Location position, Plane plane, float range, float height, int amount) {
        return MathUtils.getOctahedronPoints(position, plane, range, height, amount, 0);
    }

    public static List<Location> getOctahedronPoints(Location position, Plane plane, float range, float height, int amount, int startrotation) {
        List<Location> points = MathUtils.getCirclePoints0(position, plane, range, 4, startrotation);
        int a = (amount - 4) / 12;
        Location p1 = points.get(0);
        Location p2 = points.get(1);
        Location p3 = points.get(2);
        Location p4 = points.get(3);
        Location p5 = null;
        Location p6 = null;
        switch (plane) {
            case XZ: {
                p5 = position.add(0.0, (double)(height / 2.0f), 0.0);
                p6 = position.add(0.0, (double)(-(height / 2.0f)), 0.0);
                break;
            }
            case YZ: {
                p5 = position.add((double)(height / 2.0f), 0.0, 0.0);
                p6 = position.add((double)(-(height / 2.0f)), 0.0, 0.0);
                break;
            }
            default: {
                p5 = position.add(0.0, 0.0, (double)(height / 2.0f));
                p6 = position.add(0.0, 0.0, (double)(-(height / 2.0f)));
            }
        }
        points.addAll(MathUtils.getLinePoints(p1, p2, a));
        points.addAll(MathUtils.getLinePoints(p2, p3, a));
        points.addAll(MathUtils.getLinePoints(p3, p4, a));
        points.addAll(MathUtils.getLinePoints(p4, p1, a));
        points.addAll(MathUtils.getLinePoints(p1, p5, a));
        points.addAll(MathUtils.getLinePoints(p2, p5, a));
        points.addAll(MathUtils.getLinePoints(p3, p5, a));
        points.addAll(MathUtils.getLinePoints(p4, p5, a));
        points.addAll(MathUtils.getLinePoints(p1, p6, a));
        points.addAll(MathUtils.getLinePoints(p2, p6, a));
        points.addAll(MathUtils.getLinePoints(p3, p6, a));
        points.addAll(MathUtils.getLinePoints(p4, p6, a));
        return points;
    }

    public static List<Location> getPyramidPoints(Location position, Plane plane, float range, float height, int amount) {
        return MathUtils.getOctahedronPoints(position, plane, range, height, amount, 0);
    }

    public static List<Location> getPyramidPoints(Location position, Plane plane, float range, float height, int amount, int startrotation) {
        List<Location> points = MathUtils.getCirclePoints0(position, plane, range, 4, startrotation);
        int a = (amount - 4) / 12;
        Location p1 = points.get(0);
        Location p2 = points.get(1);
        Location p3 = points.get(2);
        Location p4 = points.get(3);
        Location p5 = null;
        switch (plane) {
            case XZ: {
                p5 = position.add(0.0, (double)(height / 2.0f), 0.0);
                break;
            }
            case YZ: {
                p5 = position.add((double)(height / 2.0f), 0.0, 0.0);
                break;
            }
            default: {
                p5 = position.add(0.0, 0.0, (double)(height / 2.0f));
            }
        }
        points.addAll(MathUtils.getLinePoints(p1, p2, a));
        points.addAll(MathUtils.getLinePoints(p2, p3, a));
        points.addAll(MathUtils.getLinePoints(p3, p4, a));
        points.addAll(MathUtils.getLinePoints(p4, p1, a));
        points.addAll(MathUtils.getLinePoints(p1, p5, a));
        points.addAll(MathUtils.getLinePoints(p2, p5, a));
        points.addAll(MathUtils.getLinePoints(p3, p5, a));
        points.addAll(MathUtils.getLinePoints(p4, p5, a));
        return points;
    }

    public static enum Plane {
        XY,
        XZ,
        YZ;

    }
}

