/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;

public class MaterialUtil {
    private static final Material[][] weaponCategories = NMSHandler.getInterface().getWeaponCategories();
    private static final Material[] yesNoWeapons;
    private static final String[] weaponCategoryNames;
    private static final String[] weaponTierNames;
    private static final Material[][] armorCategories;
    private static final String[] armorCategoryNames;
    private static final String[] armorTierNames;

    public static String capitalize(String string) {
        char[] chars = string.toLowerCase().toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
                continue;
            }
            if (!Character.isWhitespace(chars[i])) continue;
            found = false;
        }
        return String.valueOf(chars);
    }

    public static String getFriendlyName(Material material) {
        return MaterialUtil.getFriendlyName(material.toString());
    }

    public static String getFriendlyName(String string) {
        return MaterialUtil.capitalize(string.toLowerCase().replaceAll("_", " "));
    }

    public static String getWeaponRestrictionString(Set<Material> allowedWeapons) {
        StringBuilder sb = new StringBuilder("Allowed Weapons: ");
        int actualWeaponTierAmount = weaponTierNames.length - 1;
        for (int categoryIndex = 0; categoryIndex < 5; ++categoryIndex) {
            int materialIndex;
            if (actualWeaponTierAmount > weaponCategories[categoryIndex].length) {
                Heroes.log(Level.WARNING, "Invalid weaponTiers or weaponCategories, cannot build weapon restriction string. Contact developer!");
                return "*Error building string, contact Admin to check log.*";
            }
            for (materialIndex = 0; materialIndex < actualWeaponTierAmount && !allowedWeapons.contains(weaponCategories[categoryIndex][materialIndex]); ++materialIndex) {
            }
            sb.append(weaponTierNames[materialIndex]);
            sb.append("\u00a7r ");
            sb.append(weaponCategoryNames[categoryIndex]);
            sb.append("\u00a7r | ");
        }
        for (int i = 0; i < yesNoWeapons.length; ++i) {
            Material material = yesNoWeapons[i];
            boolean yes = allowedWeapons.contains(material) || !Heroes.properties.useToolsInPermittedWeapons && Util.toolsNotAlreadyWeapons.contains(material.name());
            sb.append(yes ? "\u00a7aYes \u00a7r" : "\u00a7cNo \u00a7r");
            sb.append(StringUtils.capitalize((String)material.toString().toLowerCase()));
            if (i == yesNoWeapons.length - 1) continue;
            sb.append("\u00a7r | ");
        }
        return sb.toString();
    }

    public static String getArmorRestrictionString(Set<Material> allowedArmor) {
        StringBuilder sb = new StringBuilder("Allowed Armor: ");
        int actualArmorTierAmount = armorTierNames.length - 1;
        for (int categoryIndex = 0; categoryIndex < 4; ++categoryIndex) {
            int materialIndex;
            if (actualArmorTierAmount > armorCategories[categoryIndex].length) {
                Heroes.log(Level.WARNING, "Invalid armorTiers or armorCategories, cannot build armor restriction string. Contact developer!");
                return "*Error building string, contact Admin to check log.*";
            }
            for (materialIndex = 0; materialIndex < actualArmorTierAmount && !allowedArmor.contains(armorCategories[categoryIndex][materialIndex]); ++materialIndex) {
            }
            sb.append(armorTierNames[materialIndex]);
            sb.append("\u00a7r ");
            sb.append(armorCategoryNames[categoryIndex]);
            sb.append("\u00a7r | ");
        }
        sb.append(allowedArmor.contains(Material.PUMPKIN) ? "\u00a7aYes \u00a7r" : "\u00a7cNo \u00a7r");
        sb.append("Pumpkin");
        sb.append("\u00a7r | ");
        sb.append(allowedArmor.contains(Material.TURTLE_HELMET) ? "\u00a7aYes \u00a7r" : "\u00a7cNo \u00a7r");
        sb.append("Turtle Helmet");
        sb.append("\u00a7r | ");
        sb.append(allowedArmor.contains(Material.ELYTRA) ? "\u00a7aYes \u00a7r" : "\u00a7cNo \u00a7r");
        sb.append("Elytra");
        sb.append("\u00a7r | ");
        sb.append(allowedArmor.contains(Material.SHIELD) ? "\u00a7aYes \u00a7r" : "\u00a7cNo \u00a7r");
        sb.append("Shield");
        return sb.toString();
    }

    static {
        ArrayList<Object> list = new ArrayList<Material>(Arrays.asList(Material.BOW, Material.TRIDENT, Material.SHEARS, Material.FISHING_ROD, Material.PAPER, Material.BOOK, Material.ENDER_PEARL, Material.STICK, Material.CLOCK));
        if (Properties.SUBVERSION > 13) {
            list.add(1, Material.CROSSBOW);
        }
        yesNoWeapons = list.toArray(new Material[0]);
        weaponCategoryNames = new String[]{"Sword", "Axe", "Pick", "Shovel", "Hoe"};
        list = new ArrayList<String>(Arrays.asList("\u00a79Dimd", "\u00a7fIron", "\u00a7eGold", "\u00a77Ston", "\u00a76Wood", "\u00a7cNo"));
        if (Properties.SUBVERSION > 15) {
            list.add(0, (Material)"\u00a75Neth");
        }
        weaponTierNames = list.toArray(new String[0]);
        armorCategories = NMSHandler.getInterface().getArmorCategories();
        armorCategoryNames = new String[]{"Helm", "Chest", "Legs", "Boots"};
        list = new ArrayList<String>(Arrays.asList("\u00a79Dimd", "\u00a7fIron", "\u00a7eGold", "\u00a77Chml", "\u00a76Lthr", "\u00a7cNo"));
        if (Properties.SUBVERSION > 15) {
            list.add(0, "\u00a75Neth");
        }
        armorTierNames = list.toArray(new String[0]);
    }
}

