/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.skill.Skill;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.util.Vector;

public class GeometryUtil {
    public static final Random random = new Random();
    public static final double halfPi = 1.5707963267948966;
    public static final double doublePi = Math.PI * 2;

    public static List<Location> circle(Location centerPoint, int amount, double circleRadius) {
        World world = centerPoint.getWorld();
        double increment = Math.PI * 2 / (double)amount;
        ArrayList<Location> locations = new ArrayList<Location>();
        for (int i = 0; i < amount; ++i) {
            double angle = (double)i * increment;
            double x = centerPoint.getX() + circleRadius * Math.cos(angle);
            double z = centerPoint.getZ() + circleRadius * Math.sin(angle);
            locations.add(new Location(world, x, centerPoint.getY(), z));
        }
        return locations;
    }

    public static List<Block> circleBlocks(Location centerPoint, int amount, double circleRadius) {
        World world = centerPoint.getWorld();
        double increment = Math.PI * 2 / (double)amount;
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int i = 0; i < amount; ++i) {
            double angle = (double)i * increment;
            double x = centerPoint.getX() + circleRadius * Math.cos(angle);
            double z = centerPoint.getZ() + circleRadius * Math.sin(angle);
            blocks.add(new Location(world, x, centerPoint.getY(), z).getBlock());
        }
        return blocks;
    }

    public static List<Location> getPerfectCircle(Location startingLocation, Integer radius, Integer height, boolean isHollow, boolean isSphere, int plus_y) {
        ArrayList<Location> circleblocks = new ArrayList<Location>();
        int cx = startingLocation.getBlockX();
        int cy = startingLocation.getBlockY();
        int cz = startingLocation.getBlockZ();
        for (int x = cx - radius; x <= cx + radius; ++x) {
            for (int z = cz - radius; z <= cz + radius; ++z) {
                for (int y = isSphere ? cy - radius : cy; y < (isSphere ? cy + radius : cy + height); ++y) {
                    double dist = (cx - x) * (cx - x) + (cz - z) * (cz - z) + (isSphere ? (cy - y) * (cy - y) : 0);
                    if (!(dist < (double)(radius * radius)) || isHollow && dist < (double)((radius - 1) * (radius - 1))) continue;
                    Location l = new Location(startingLocation.getWorld(), (double)x, (double)(y + plus_y), (double)z);
                    circleblocks.add(l);
                }
            }
        }
        return circleblocks;
    }

    public static boolean isInBorder(Location center, Location targetLocation, int radiusX, int radiusY, int radiusZ) {
        int x1 = center.getBlockX();
        int y1 = center.getBlockY();
        int z1 = center.getBlockZ();
        int x2 = targetLocation.getBlockX();
        int y2 = targetLocation.getBlockY();
        int z2 = targetLocation.getBlockZ();
        return x2 < x1 + radiusX && x2 > x1 - radiusX && y2 < y1 + radiusY && y2 > y1 - radiusY && z2 < z1 + radiusZ && z2 > z1 - radiusZ;
    }

    public static List<Location> helix(Location center, int particlesPerCircle, double radius, double height, double yInterval) {
        double y = 0.0;
        World world = center.getWorld();
        double increment = Math.PI * 2 / (double)particlesPerCircle;
        ArrayList<Location> locations = new ArrayList<Location>();
        for (int i = 0; i < particlesPerCircle * 40 && !(y <= height); y += yInterval, ++i) {
            double angle = (double)i * increment;
            double x = center.getX() + radius * Math.cos(angle);
            double z = center.getZ() + radius * Math.sin(angle);
            locations.add(new Location(world, x, y, z));
        }
        return locations;
    }

    public static List<Location> filledCircle(Location center, int basePointAmount, double radius) {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (double r = 0.0; r <= radius; r += 1.0) {
            List<Location> circle = GeometryUtil.circle(center, r == 0.0 ? 1 : basePointAmount++, r);
            locations.addAll(circle);
        }
        return locations;
    }

    public static List<Block> filledCircleBlocks(Location center, int basePointAmount, double radius) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (double r = 0.0; r <= radius; r += 1.0) {
            List<Block> circle = GeometryUtil.circleBlocks(center, r == 0.0 ? 1 : basePointAmount++, r);
            blocks.addAll(circle);
        }
        return blocks;
    }

    public static List<Location> blockSquare(Location center, int width) {
        Location l;
        int z;
        int startX = center.getBlockX() - width;
        int endX = center.getBlockX() + width;
        int startZ = center.getBlockZ() - width;
        int endZ = center.getBlockZ() + width;
        ArrayList<Location> locations = new ArrayList<Location>();
        int x = startX;
        int y = center.getBlockY();
        for (z = startZ; z <= endZ; ++z) {
            l = new Location(center.getWorld(), (double)x, (double)y, (double)z);
            if (locations.contains(l)) continue;
            locations.add(l);
        }
        x = endX;
        for (z = startZ; z <= endZ; ++z) {
            l = new Location(center.getWorld(), (double)x, (double)y, (double)z);
            if (locations.contains(l)) continue;
            locations.add(l);
        }
        z = startZ;
        for (x = startX; x <= endX; ++x) {
            l = new Location(center.getWorld(), (double)x, (double)y, (double)z);
            if (locations.contains(l)) continue;
            locations.add(l);
        }
        z = endZ;
        for (x = startX; x <= endX; ++x) {
            l = new Location(center.getWorld(), (double)x, (double)y, (double)z);
            if (locations.contains(l)) continue;
            locations.add(l);
        }
        return locations;
    }

    public static List<Location> line(Location loc1, Location loc2, double pointQuantity) {
        ArrayList<Location> points = new ArrayList<Location>();
        Vector dir = loc2.toVector().subtract(loc1.toVector()).divide(new Vector(pointQuantity, pointQuantity, pointQuantity));
        double dist = loc1.distance(loc2);
        Location to = loc1.clone();
        double traveled = 0.0;
        while (traveled < Math.abs(dist)) {
            to.add(dir);
            points.add(to);
            traveled = Math.abs(to.distance(loc1));
        }
        return points;
    }

    public static List<LivingEntity> getEntitiesInFrontOf(Location loc, double dist) {
        Vector look = loc.getDirection().normalize().multiply(dist);
        Location l = loc.add(look);
        ArrayList<LivingEntity> toReturn = new ArrayList<LivingEntity>();
        Snowball test = (Snowball)loc.getWorld().spawnEntity(loc, EntityType.SNOWBALL);
        test.remove();
        for (Entity e : test.getNearbyEntities(dist, dist, dist)) {
            LivingEntity le;
            if (!(e instanceof LivingEntity) || !((le = (LivingEntity)e).getLocation().distance(l) <= dist)) continue;
            toReturn.add(le);
        }
        return toReturn;
    }

    public static List<LivingEntity> getEntitiesInFrontOf(LivingEntity base, double dist) {
        return GeometryUtil.getEntitiesInFrontOf(base.getEyeLocation(), dist);
    }

    public static List<LivingEntity> getTargetableInRange(Hero ap, Skill sp, double dist) {
        return GeometryUtil.getTargetableInRange(ap, (Entity)ap.getPlayer(), sp, dist);
    }

    public static List<LivingEntity> getTargetableInRange(Hero ap, Entity target, Skill sp, double dist) {
        ArrayList<LivingEntity> toReturn = new ArrayList<LivingEntity>();
        for (Entity e : target.getNearbyEntities(dist, dist, dist)) {
            if (!(e instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)e;
            if (le instanceof Player) {
                Player p = (Player)le;
                Hero h = ((Heroes)Bukkit.getPluginManager().getPlugin("Heroes")).getCharacterManager().getHero(p);
                if ((!ap.hasParty() || !ap.getParty().getMembers().contains(h)) && p.getGameMode() != GameMode.CREATIVE && p.getGameMode() != GameMode.SPECTATOR && !h.hasEffectType(EffectType.INVULNERABILITY)) continue;
            }
            toReturn.add(le);
        }
        return toReturn;
    }

    public static Vector getRandomNormal() {
        double x = random.nextDouble() * (double)(random.nextBoolean() ? -1 : 1);
        double y = random.nextDouble() * (double)(random.nextBoolean() ? -1 : 1);
        double z = random.nextDouble() * (double)(random.nextBoolean() ? -1 : 1);
        return new Vector(x, y, z);
    }

    public static boolean canSee(Location loc1, Location loc2) {
        Vector dir = loc2.toVector().subtract(loc1.toVector()).divide(new Vector(15, 15, 15));
        double dist = loc1.distance(loc2);
        Location to = loc1.clone();
        double traveled = 0.0;
        while (traveled < Math.abs(dist)) {
            if (to.getBlock().getType().isSolid() && to.getBlock().getType() != Material.DISPENSER) {
                return false;
            }
            to.add(dir);
            traveled = Math.abs(to.distance(loc1));
        }
        return true;
    }

    public static Location getTargetLocation(Player player, double maxDist) {
        Vector look = player.getLocation().getDirection().normalize().divide(new Vector(10, 10, 10));
        double distTraveled = 0.0;
        Location orig = player.getEyeLocation().clone();
        Location to = player.getEyeLocation().clone();
        while (distTraveled < maxDist) {
            to.add(look);
            if (to.getBlock().getType().isSolid()) {
                to.subtract(look.multiply(2));
                break;
            }
            distTraveled = to.distance(orig);
        }
        return to;
    }

    public static List<Location> pentagram(Location base, double radius, int pointsPerLine, int pointsInCircle) {
        List<Location> pentagon = GeometryUtil.circle(base, 5, radius);
        Location top = pentagon.get(0);
        Location tRight = pentagon.get(1);
        Location bRight = pentagon.get(2);
        Location bLeft = pentagon.get(3);
        Location tLeft = pentagon.get(4);
        Vector topToBLeft = top.toVector().subtract(bLeft.toVector());
        Vector topToBRight = top.toVector().subtract(bRight.toVector());
        Vector tLeftToTRight = tLeft.toVector().subtract(tRight.toVector());
        return pentagon;
    }

    public static Location getClosestLocTo(Location l, List<Location> locs) {
        Location closest = null;
        for (Location loc : locs) {
            if (closest == null) {
                closest = loc;
                continue;
            }
            if (!(closest.distance(l) > loc.distance(l))) continue;
            closest = loc;
        }
        return closest;
    }

    public static Vector rotateAroundAxisX(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = v.getY() * cos - v.getZ() * sin;
        double z = v.getY() * sin + v.getZ() * cos;
        return v.setY(y).setZ(z);
    }

    public static Vector rotateAroundAxisY(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos + v.getZ() * sin;
        double z = v.getX() * -sin + v.getZ() * cos;
        return v.setX(x).setZ(z);
    }

    public static Vector rotateAroundAxisZ(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos - v.getY() * sin;
        double y = v.getX() * sin + v.getY() * cos;
        return v.setX(x).setY(y);
    }

    public static final Vector rotateVector(Vector v, double angleX, double angleY, double angleZ) {
        GeometryUtil.rotateAroundAxisX(v, angleX);
        GeometryUtil.rotateAroundAxisY(v, angleY);
        GeometryUtil.rotateAroundAxisZ(v, angleZ);
        return v;
    }

    public static Vector rotateVector(Vector v, Location location) {
        return GeometryUtil.rotateVector(v, location.getYaw(), location.getPitch());
    }

    public static Vector rotateVector(Vector v, float yawDegrees, float pitchDegrees) {
        double yaw = Math.toRadians(-1.0f * (yawDegrees + 90.0f));
        double pitch = Math.toRadians(-pitchDegrees);
        double cosYaw = Math.cos(yaw);
        double cosPitch = Math.cos(pitch);
        double sinYaw = Math.sin(yaw);
        double sinPitch = Math.sin(pitch);
        double initialX = v.getX();
        double initialY = v.getY();
        double x = initialX * cosPitch - initialY * sinPitch;
        double y = initialX * sinPitch + initialY * cosPitch;
        double initialZ = v.getZ();
        double z = initialZ * cosYaw - x * sinYaw;
        x = initialZ * sinYaw + x * cosYaw;
        return new Vector(x, y, z);
    }

    public static double angleToXAxis(Vector vector) {
        return Math.atan2(vector.getX(), vector.getY());
    }
}

